/*! \file  ContourToNodesx.c
 */

#include "./ContourToNodesx.h"

int ContourToNodesx( Vector<IssmPDouble>** pflags,double* x, double* y, int nods, Contour<IssmPDouble>** contours,int numcontours,int edgevalue){

	int i;
	int m,n;

	/*Contour:*/
	Contour<IssmPDouble>* contouri=NULL;
	int      numnodes;
	double*  xc=NULL;
	double*  yc=NULL;
	double   value;

	/*output: */
	Vector<IssmPDouble>* flags=NULL;

	flags=new Vector<IssmPDouble>(nods);

	/*Loop through all contours: */
	for (i=0;i<numcontours;i++){
		contouri=*(contours+i);
		numnodes=contouri->nods;
		xc=contouri->x;
		yc=contouri->y;
		IsInPoly(flags,xc,yc,numnodes,x,y,0,nods,edgevalue);
	}

	/*Assemble vector: */
	flags->Assemble();

	/*Assign output pointers: */
	*pflags=flags;
	
	return 1;
}

int ContourToNodesx( Vector<IssmPDouble>** pflags,double* x, double* y, int nods, DataSet* contours, int edgevalue){

	int i;
	int m,n;

	/*Contour:*/
	Contour<IssmPDouble>* contouri=NULL;
	int      numnodes;
	double*  xc=NULL;
	double*  yc=NULL;
	double   value;

	/*output: */
	Vector<IssmPDouble>* flags=NULL;

	flags=new Vector<IssmPDouble>(nods);

	/*Loop through all contours: */
	if(contours){
		for (i=0;i<contours->Size();i++){
			Contour<IssmPDouble>* contour=(Contour<IssmPDouble>*)contours->GetObjectByOffset(i);
			IsInPoly(flags,contour->x,contour->y,contour->nods,x,y,0,nods,edgevalue);
		}
	}

	/*Assemble vector: */
	flags->Assemble();

	/*Assign output pointers: */
	*pflags=flags;
	
	return 1;
}
