/*
 * TriMesh: mesh a domain using an .exp file
 */

#include "./TriMesh.h"

WRAPPER(TriMesh){
	
	/* input: */
	char   *domainname = NULL;
	char   *riftsname  = NULL;
	double  area;

	/*intermediary: */
	DataSet *domain = NULL;
	DataSet *rifts  = NULL;

	/* output: */
	Matrix<double> *index             = NULL;
	Vector<double> *x                 = NULL;
	Vector<double> *y                 = NULL;
	Matrix<double> *segments          = NULL;
	Vector<double> *segmentmarkerlist = NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments: */
	CHECKARGUMENTS(NLHS,NRHS,&TriMeshUsage);
	
	/*Fetch data needed for meshing: */
	FetchData(&domainname,DOMAINOUTLINE);
	FetchData(&riftsname,RIFTSOUTLINE);
	FetchData(&area,AREA);

	/*Read domain outline: */
	domain = DomainOutlineRead(domainname);
	rifts  = DomainOutlineRead(riftsname);

	/*call x core: */
	TriMeshx(&index,&x,&y,&segments,&segmentmarkerlist,domain,rifts,area);

	/*write outputs: */
	WriteData(INDEX,index);
	WriteData(X,x);
	WriteData(Y,y);
	WriteData(SEGMENTS,segments);
	WriteData(SEGMENTMARKERLIST,segmentmarkerlist);

	/*free ressources: */
	delete domain;
	delete rifts;
	delete index;
	delete x;
	delete y;
	delete segments;
	delete segmentmarkerlist;

	/*end module: */
	MODULEEND();
}

void TriMeshUsage(void) //{{{1
{
	_printLine_("");
	_printLine_("   usage: [index,x,y,segments,segmentmarkers]=TriMesh(domainoutlinefilename,rifts,area) ");
	_printLine_("      where: index,x,y defines a triangulation, segments is an array made ");
	_printLine_("      of exterior segments to the mesh domain outline, segmentmarkers is an array flagging each segment, ");
	_printLine_("      outlinefilename an Argus domain outline file, ");
	_printLine_("      area is the maximum area desired for any element of the resulting mesh, ");
	_printLine_("");
}
//}}}
