/*! \file  ContourToNodesx.c
 */

#include "./ContourToNodesx.h"

int ContourToNodesx( Vector<IssmDouble>** pflags,double* x, double* y, int nods, Contour** contours,int numcontours,int edgevalue){

	int i;
	int m,n;

	/*Contour:*/
	Contour* contouri=NULL;
	int      numnodes;
	double*  xc=NULL;
	double*  yc=NULL;
	double   value;

	/*output: */
	Vector<IssmDouble>* flags=NULL;

	flags=new Vector<IssmDouble>(nods);

	/*Loop through all contours: */
	for (i=0;i<numcontours;i++){
		contouri=*(contours+i);
		numnodes=contouri->nods;
		xc=contouri->x;
		yc=contouri->y;
		IsInPoly(flags,xc,yc,numnodes,x,y,0,nods,edgevalue);
	}

	/*Assemble vector: */
	flags->Assemble();

	/*Assign output pointers: */
	*pflags=flags;
	
	return 1;
}

int ContourToNodesx( Vector<IssmDouble>** pflags,double* x, double* y, int nods, DataSet* contours, int edgevalue){

	int i;
	int m,n;

	/*Contour:*/
	Contour* contouri=NULL;
	int      numnodes;
	double*  xc=NULL;
	double*  yc=NULL;
	double   value;

	/*output: */
	Vector<IssmDouble>* flags=NULL;

	flags=new Vector<IssmDouble>(nods);

	/*Loop through all contours: */
	if(contours){
		for (i=0;i<contours->Size();i++){
			Contour* contour=(Contour*)contours->GetObjectByOffset(i);
			IsInPoly(flags,contour->x,contour->y,contour->nods,x,y,0,nods,edgevalue);
		}
	}

	/*Assemble vector: */
	flags->Assemble();

	/*Assign output pointers: */
	*pflags=flags;
	
	return 1;
}
