/*!\file KMLMeshWrite.h
 * \brief: prototype for KML mesh writer mex module.
 */

#ifndef _KMLMESHWRITE_H
#define _KMLMESHWRITE_H

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
	#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

/*For python modules: needs to come before header files inclusion*/
#ifdef _HAVE_PYTHON_
#define PY_ARRAY_UNIQUE_SYMBOL PythonIOSymbol
#endif

/* local prototypes: */
void KMLMeshWriteUsage(void);

#include "../../c/include/globals.h"
#include "../../c/modules/modules.h"
#include "../../c/Container/Container.h"
#include "../../c/shared/shared.h"
#include "../../c/issm-binding.h"

#undef __FUNCT__ 
#define __FUNCT__  "KMLMeshWrite"


/* serial input macros: */
#define NAME          prhs[0]
#define NOTES         prhs[1]
#define ELEMHANDLE    prhs[2]
#define NODECONHANDLE prhs[3]
#define LATHANDLE     prhs[4]
#define LNGHANDLE     prhs[5]
#define PARTHANDLE    prhs[6]
#define DATAHANDLE    prhs[7]
#define CMAPHANDLE    prhs[8]
#define FILENAME      prhs[9]

/* serial output macros: */
#define ERRORFLAG (mxArray**)&plhs[0]

/* serial arg counts: */
#undef NRHS
#define NRHS 10
#undef NLHS
#define NLHS  1

#endif
