/*
	KrigingUsage.h
*/

#ifndef _KRIGING_H_
#define _KRIGING_H_

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
	#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

/*For python modules: needs to come before header files inclusion*/
#ifdef _HAVE_PYTHON_
#define PY_ARRAY_UNIQUE_SYMBOL PythonIOSymbol
#endif

/* local prototypes: */
void KrigingUsage(void);

#include "../../c/include/globals.h"
#include "../../c/modules/modules.h"
#include "../../c/shared/shared.h"
#include "../../c/issm-binding.h"

#undef __FUNCT__ 
#define __FUNCT__  "Kriging"
    
/* serial input macros: */
#define X            (mxArray *)prhs[0]
#define Y            (mxArray *)prhs[1]
#define OBSERVATIONS (mxArray *)prhs[2]
#define XINTERP      (mxArray *)prhs[3]
#define YINTERP      (mxArray *)prhs[4]

/* serial output macros: */
#define PREDICTIONS (mxArray**)&plhs[0]
#define ERROR       (mxArray**)&plhs[1]

/* serial arg counts: */
#undef NLHS
#define NLHS  2
#undef NRHS
#define NRHS  5

#endif  /* _KRIGING_H_ */
