/*
	ElementConnectivity.h
*/

#ifndef _ELEMENTCONNECTIVITY_H
#define _ELEMENTCONNECTIVITY_H

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
	#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

/*Very important definition in case we are compiling a python module!: needs to come before header files inclusion*/
#ifdef _HAVE_PYTHON_
#define PY_ARRAY_UNIQUE_SYMBOL PythonIOSymbol
#endif

/*Header files: */
#include "../../c/include/globals.h"
#include "../../c/toolkits/toolkits.h"
#include "../../c/include/include.h"
#include "../../c/modules/modules.h"
#include "../../c/Container/Container.h"
#include "../../c/shared/shared.h"
#include "../../c/issm-binding.h"
#include "../../c/io/io.h"
#include "../../c/EnumDefinitions/EnumDefinitions.h"

#ifdef _HAVE_MATLAB_MODULES_
/* serial input macros: */
/* serial input macros: */
#define ELEMENTS (mxArray*)prhs[0]
#define NODECONNECTIVITY (mxArray*)prhs[1]
/* serial output macros: */
#define ELEMENTCONNECTIVITY (mxArray**)&plhs[0]
#endif

#ifdef _HAVE_PYTHON_MODULES_
/* serial input macros: */
/* serial input macros: */
#define ELEMENTS PyTuple_GetItem(args,0)
#define NODECONNECTIVITY PyTuple_GetItem(args,1)
/* serial output macros: */
#define ELEMENTCONNECTIVITY output,0
#endif

#undef __FUNCT__ 
#define __FUNCT__  "ElementConnectivity"

/* serial arg counts: */
#undef NLHS
#define NLHS  1
#undef NRHS
#define NRHS  2

/* local prototypes: */
void ElementConnectivityUsage(void);

#endif  /* _ELEMENTCONNECTIVITY_H */
