/*!\file:  Chaco.h
 * \brief header file for Chaco module.
 */ 

#ifndef _CHACO_H
#define _CHACO_H

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
	#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

/* local prototypes: */
void ChacoUsage(void);

#include <stdio.h>
#include <string.h>    /*  strcasecmp  */
#include <time.h>      /*  clock,time,difftime  */

#include "../../c/include/globals.h"
#include "../../c/modules/modules.h"
#include "../../c/Container/Container.h"
#include "../../c/shared/shared.h"
#include "../../c/issm-binding.h"
    
/* serial input macros: */
#define A_IN (mxArray*)prhs[0]
#define VWGTS_IN (mxArray*)prhs[1]
#define EWGTS_IN (mxArray*)prhs[2]
#define X_IN (mxArray*)prhs[3]
#define Y_IN (mxArray*)prhs[4]
#define Z_IN (mxArray*)prhs[5]
#define OPTNS_IN (mxArray*)prhs[6]
#define NPARTS_IN (mxArray*)prhs[7]
#define GOAL_IN (mxArray*)prhs[8]

/* serial output macros: */
#define ASSGN_OUT (mxArray**)&plhs[0]

/* serial arg counts: */
#undef NLHS
#define NLHS  1
#undef NRHS
#define NRHS  9

#undef __FUNCT__ 
#define __FUNCT__  "Chaco"

#endif  /* _CHACO_H */
