function md=loadmodel(path)
%LOADMODEL - load a model using built-in load module
%
%   check that model prototype has not changed. if so, adapt to new model prototype.
%
%   Usage:
%      md=loadmodel(path)

if nargout~=1,
	error('loadmodel usage error: md=loadmodel(path)');
end

try,
	s=load(path,'-mat');
	%get name of model variable
	fieldname=char(fieldnames(s));
	md=eval(['s.' fieldname]);
	if ~strcmpi(class(md),'model'),
		md2=model;
		md2=structtomodel(md2,md);
		md=md2;
		clear md2;
	end
	%assignin('caller',fieldname,md);
catch
	error(['could not load model ' path]);
end
