/*!\file:  Solverx.h
 * \brief solver
 */ 

#ifndef _SOLVERX_H
#define _SOLVERX_H

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../classes/objects/objects.h"

/* local prototypes: */
void	Solverx(Vector** puf, Matrix* Kff, Vector* pf, Vector* uf0,Vector* df, Parameters* parameters);

#ifdef _HAVE_PETSC_
void	SolverxPetsc(PetscVec** puf, PetscMat* Kff, PetscVec* pf, PetscVec* uf0,PetscVec* df, Parameters* parameters);
void	SolverxPetsc(Vec* puf, Mat Kff, Vec pf, Vec uf0,Vec df, Parameters* parameters);
void  DofTypesToIndexSet(IS* pisv, IS* pisp, Vec df,int typeenum);
#endif

void SolverxSeq(SeqVec** puf,SeqMat* Kff, SeqVec* pf,Parameters* parameters);
void SolverxSeq(IssmPDouble *X, IssmPDouble *A, IssmPDouble *B,int n);

#ifdef _HAVE_ADOLC_
void SolverxSeq(IssmDouble *X,IssmDouble *A,IssmDouble *B,int n, Parameters* parameters);
ADOLC_ext_fct EDF_for_solverx;
#endif

#endif  /* _SOLVERX_H */

