/*
 * GenericParam.h
 *
 *  Created on: Aug 29, 2012
 *      Author: utke
 */

#ifndef GENERICPARAM_H_
#define GENERICPARAM_H_

/*Headers:*/
/*{{{*/
#ifdef HAVE_CONFIG_H
        #include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./Param.h"
#include "../../../include/include.h"
#include "../../../shared/shared.h"
/*}}}*/

/**
 * here we have a class that holds an instance of P
 * but because it should live side by side with
 * the other instances derived from Param it - unfortunately -
 * inherits all the accessors that are useless in this context
 */
template <class P> class GenericParam: public Param{

        private:
                P myP;
                int myEnumVal;

        public:
                /*GenericParam constructors, destructors: {{{*/
                GenericParam(int enumVal) : myEnumVal(enumVal){};
                ~GenericParam(){};
                /*}}}*/
                /*Object virtual functions definitions:{{{ */
                // unfortunately having such a printer method implies
                // that P must provide the friend <<  operator
                void  DeepEcho() {
                  _printLine_("GenericParam:");
                  _printLine_("   enum:  " << myEnumVal << " (" << EnumToStringx(myEnumVal) << ")");
                  _printLine_("   value: " << myP);;
                }
                 void  Echo() {DeepEcho();};
                int   Id(){ return -1; };
                int   MyRank() { extern int my_rank; return my_rank;} ;
                int   ObjectEnum() {return AdolcParamEnum;};

                // the "copy"  has to implement the base class abstract function
                // but I would prefer to drop this not to hide a "new" in here because
                // it does not clarify  ownership of the newed up instance...
                // use the default copy constructor instead
                Object* copy() { return new GenericParam<P>(*this); };
                /*}}}*/
                /*Param vritual function definitions: {{{*/
                int   InstanceEnum(){return myEnumVal;}
                void GetParameterName(char**pname) {EnumToStringx(pname,this->myEnumVal);}

                P& GetParameterValue() { return myP;}
                const P& GetParameterValue()const { return myP;};

                // none of these apply ...
                void  GetParameterValue(bool* pbool){_error_("Param "<< EnumToStringx(myEnumVal) << " cannot return a bool");}
                void  GetParameterValue(int* pinteger){_error_("Param "<< EnumToStringx(myEnumVal) << " cannot return an integer");}
                void  GetParameterValue(int** pintarray,int* pM){_error_("Param "<< EnumToStringx(myEnumVal) << " cannot return an array of integers");}
                void  GetParameterValue(int** pintarray,int* pM,int* pN){_error_("Param "<< EnumToStringx(myEnumVal) << " cannot return an array of integers");}
                void  GetParameterValue(IssmDouble* pIssmDouble){_error_("Param "<< EnumToStringx(myEnumVal) << " cannot return a IssmDouble");}
                void  GetParameterValue(IssmDouble* pdouble,IssmDouble time){_error_("Param "<< EnumToStringx(myEnumVal) << " cannot return a IssmDouble for a given time");}
                void  GetParameterValue(char** pstring){_error_("Param "<< EnumToStringx(myEnumVal) << " cannot return a string");}
                void  GetParameterValue(char*** pstringarray,int* pM){_error_("Param "<< EnumToStringx(myEnumVal) << " cannot return a string array");}
                void  GetParameterValue(IssmDouble** pIssmDoublearray,int* pM){_error_("Param "<< EnumToStringx(myEnumVal) << " cannot return a IssmDouble array");}
                void  GetParameterValue(IssmDouble** pIssmDoublearray,int* pM, int* pN){_error_("Param "<< EnumToStringx(myEnumVal) << " cannot return a IssmDouble array");}
                void  GetParameterValue(IssmDouble*** parray, int* pM,int** pmdims, int** pndims){_error_("Param "<< EnumToStringx(myEnumVal) << " cannot return a matrix array");}
                void  GetParameterValue(Vector** pvec){_error_("Param "<< EnumToStringx(myEnumVal) << " cannot return a Vec");}
                void  GetParameterValue(Matrix** pmat){_error_("Param "<< EnumToStringx(myEnumVal) << " cannot return a Mat");}
                void  GetParameterValue(FILE** pfid){_error_("Param "<< EnumToStringx(myEnumVal) << " cannot return a FILE");}

                void  SetValue(bool boolean){_error_("Param "<< EnumToStringx(myEnumVal) << " cannot hold a bool");}
                void  SetValue(int integer){_error_("Param "<< EnumToStringx(myEnumVal) << " cannot hold an integer");}
                void  SetValue(int* intarray,int M){_error_("Param "<< EnumToStringx(myEnumVal) << " cannot hold an int array");}
                void  SetValue(int* intarray,int M,int N){_error_("Param "<< EnumToStringx(myEnumVal) << " cannot hold an int array");}
                void  SetValue(IssmDouble scalar){_error_("Param "<< EnumToStringx(myEnumVal) << " cannot hold an IssmDouble");}
                void  SetValue(char* string){_error_("Param "<< EnumToStringx(myEnumVal) << " cannot hold a string");}
                void  SetValue(char** stringarray,int M){_error_("Param "<< EnumToStringx(myEnumVal) << " cannot hold a string array");}
                void  SetValue(IssmDouble* IssmDoublearray,int M){_error_("Param "<< EnumToStringx(myEnumVal) << " cannot hold a IssmDouble array");}
                void  SetValue(IssmDouble* pIssmDoublearray,int M,int N){_error_("Param "<< EnumToStringx(myEnumVal) << " cannot hold a IssmDouble array");}
                void  SetValue(Vector* vec){_error_("Param "<< EnumToStringx(myEnumVal) << " cannot hold a Vec");}
                void  SetValue(Matrix* mat){_error_("Param "<< EnumToStringx(myEnumVal) << " cannot hold a Mat");}
                void  SetValue(FILE* fid){_error_("Param "<< EnumToStringx(myEnumVal) << " cannot hold a FILE");}
                void  SetValue(IssmDouble** array, int M, int* mdim_array, int* ndim_array){_error_("Param "<< EnumToStringx(myEnumVal) << " cannot hold an array of matrices");}
                void  UnitConversion(int direction_enum) {/* nothing useful here either */};

                /*}}}*/
};


#endif /* GENERICPARAM_H_ */
