function [bx by b]=basalstress(md,options_structure,width,i,type);
%BASALSTRESS - compute basal stress from basal drag and geometric information. 
%
%   Usage:
%      basalstress(md,options_structure,width,i,type);
%
%   See also: plot_basaldrag

%check layer
if strcmpi(md.type,'3d')
	if options_structure.layer~=1,
		disp('plot_basaldrag warning: basal drag is displayed in the lower layer')
		options_structure.layer=1;
	end
end

%compute exponents
s=averaging(md,1./md.p,0);
r=averaging(md,md.p./md.q,0);

%compute horizontal velocity
ub=sqrt(md.vx.^2+md.vy.^2)/md.yts;
ubx=md.vx/md.yts;
uby=md.vy/md.yts;

%compute basal drag
bx=(md.g*(md.rho_ice*md.thickness+md.rho_water*md.bed)).^r.*(md.drag).^2.*ubx.^s;
by=(md.g*(md.rho_ice*md.thickness+md.rho_water*md.bed)).^r.*(md.drag).^2.*uby.^s;
b=(md.g*(md.rho_ice*md.thickness+md.rho_water*md.bed)).^r.*(md.drag).^2.*ub.^s;
