/*
 * \file EnumDefinitions.cpp:
 * \brief: enum functions for our objects
 */

#include "./EnumDefinitions.h"

/*objects: */
int NodeEnum(void){                     return           1; }
int SpcEnum(void){                      return           4; }
int ParamEnum(void){                    return           5; }
int RgbEnum(void){                      return           6; }
int ResultEnum(void){                   return           7; }

/*analysis types: */
int DiagnosticAnalysisEnum(void){       return          20; }
int ControlAnalysisEnum(void){          return          21; }
int ThermalAnalysisEnum(void){          return          22; }
int PrognosticAnalysisEnum(void){       return          23; }
int MeltingAnalysisEnum(void){          return          24; }
int SlopeComputeAnalysisEnum(void){     return          25; }
int StokesAnalysisEnum(void){           return          26; }
int HutterAnalysisEnum(void){           return          27; }
int SurfaceXAnalysisEnum(void){         return          28; }
int SurfaceYAnalysisEnum(void){         return          29; }
int BedXAnalysisEnum(void){             return          30; }
int BedYAnalysisEnum(void){             return          31; }
int HorizAnalysisEnum(void){            return          32; }
int VertAnalysisEnum(void){             return          33; }
int NoneAnalysisEnum(void){             return          34; }
int SteadyAnalysisEnum(void){           return          35; }
int TransientAnalysisEnum(void){        return          36; }
int AdjointAnalysisEnum(void){        return            37; }
int InverseAnalysisEnum(void){        return            38; }
int GradientAnalysisEnum(void){        return           39; }

/*datasets: */
int ElementsEnum(void){                 return          40; }
int NodesEnum(void){                    return          41; }
int ConstraintsEnum(void){              return          42; }
int LoadsEnum(void){                    return          43; }
int MaterialsEnum(void){                return          44; }
int ParametersEnum(void){               return          45; }
int ResultsEnum(void){                  return          46; }

/*Elements: */
int ElementEnum(void){                  return         100; }
int TriaEnum(void){                     return         101; }
int PentaEnum(void){                    return         102; }
int SingEnum(void){                     return         103; }
int BeamEnum(void){                     return         104; }

/*Loads: */
int LoadEnum(void){                     return         200; }
int IcefrontEnum(void){                 return         201; }
int PenpairEnum(void){                  return         202; }
int PengridEnum(void){                  return         203; }

/*Materials: */
int MaterialEnum(void){                 return         300; }
int MaticeEnum(void){                   return         301; }
int MatparEnum(void){                   return         302; }

/*formulations: */
int NoneEnum(void){                     return           0; }
int HutterEnum(void){                   return           1; }
int MacAyealEnum(void){                 return           2; }
int PattynEnum(void){                   return           3; }
int StokesEnum(void){                   return           4; }

/*inputs: */
int InputEnum(void){                    return         310; }



/*functions on enums: */
int EnumIsElement(int en){
	if ((en>=100) && (en<=110))return 1;
	else return 0;
}

int EnumIsLoad(int en){
	if ((en>=200) && (en<=210))return 1;
	else return 0;
}
int EnumIsMaterial(int en){
	if ((en>=300) && (en<=310))return 1;
	else return 0;
}
