/*!\file: PentaHook.h
 * \brief prototypes for PentaHook.h
 */ 

#ifndef _PENTAHOOK_H_
#define  _PENTAHOOK_H_

class Hook;
class TriaHook;
class IoModel;

class PentaHook{

	public: 
		int   numanalyses; //number of analysis types
		Hook** hnodes; // 6 nodes for each analysis type
		Hook*  hmaterial; // 1 ice material
		Hook*  hmatpar; // 1 material parameter
		Hook*  hneighbors; // 2 elements, first down, second up

		/*FUNCTION constructors, destructors {{{*/
		PentaHook();
		PentaHook(int in_numanalyses,int material_id, IoModel* iomodel);
		~PentaHook();
		void SetHookNodes(int* node_ids,int analysis_counter);
		void SpawnTriaHook(TriaHook* triahook,int* indices);
		void InitHookNeighbors(int* element_ids);
		/*}}}*/
};


#endif //ifndef _PENTAHOOK_H_

