/*!\file PentaHook.c
 * \brief: implementation of the PentaHook object
 */

/*Headers:*/
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../../classes.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../shared/shared.h"
#include "../../../Container/Container.h"
#include "../../../include/include.h"
/*}}}*/

/*Object constructors and destructor*/
/*FUNCTION PentaHook::PentaHook(){{{*/
PentaHook::PentaHook(){
	numanalyses=UNDEF;
	this->hnodes=NULL;
	this->hmaterial=NULL;
	this->hmatpar=NULL;
	this->hneighbors=NULL;
}
/*}}}*/
/*FUNCTION PentaHook::~PentaHook(){{{*/
PentaHook::~PentaHook(){

	int i;

	for(i=0;i<this->numanalyses;i++){
		if (this->hnodes[i]) delete this->hnodes[i];
	}
	delete [] this->hnodes;
	delete hmaterial;
	delete hmatpar;
	delete hneighbors;
}
/*}}}*/
/*FUNCTION PentaHook::PentaHook(int in_numanalyses,int material_id, int matpar_id){{{*/
PentaHook::PentaHook(int in_numanalyses,int material_id, IoModel* iomodel){

	/*intermediary: */
	int matpar_id;
	
	/*retrieve parameters: */
	iomodel->Constant(&matpar_id,MeshNumberofelementsEnum); matpar_id++;

	this->numanalyses=in_numanalyses;
	this->hnodes=new Hook*[in_numanalyses];
	this->hmaterial=new Hook(&material_id,1);
	this->hmatpar=new Hook(&matpar_id,1);
	this->hneighbors=NULL; 

	//Initialize hnodes as NULL
	for(int i=0;i<this->numanalyses;i++){
		this->hnodes[i]=NULL;
	}

}
/*}}}*/

/*FUNCTION PentaHook::SetHookNodes{{{*/
void PentaHook::SetHookNodes(int* node_ids,int analysis_counter){
	this->hnodes[analysis_counter]= new Hook(node_ids,6);

}
/*}}}*/
/*FUNCTION PentaHook::InitHookNeighbors{{{*/
void PentaHook::InitHookNeighbors(int* element_ids){
	this->hneighbors=new Hook(element_ids,2);

}
/*}}}*/
/*FUNCTION PentaHook::SpawnTriaHook{{{*/
void PentaHook::SpawnTriaHook(TriaHook* triahook,int* indices){

	int i;
	int zero=0;

	triahook->numanalyses=this->numanalyses;
	triahook->hnodes=new Hook*[this->numanalyses];

	for(i=0;i<this->numanalyses;i++){
		/*Do not do anything if Hook is empty*/
		if (!this->hnodes[i] || this->hnodes[i]->GetNum()==0){
			triahook->hnodes[i]=NULL;
		}
		else{
			/*Else, spawn Hook*/
			triahook->hnodes[i]=this->hnodes[i]->Spawn(indices,3);
		}
	}
	// do not spawn hmaterial. material will be taken care of by Penta
	triahook->hmaterial=NULL;
	triahook->hmatpar=(Hook*)this->hmatpar->copy();
}
/*}}}*/
