#module imports
from fielddisplay import fielddisplay
from EnumDefinitions import *
from checkfield import *
from WriteData import *

class timestepping(object):
	"""
	TIMESTEPPING Class definition

	   Usage:
	      timestepping=timestepping();
	"""

	#properties
	def __init__(self):
		# {{{ Properties
		self.start_time      = 0
		self.final_time      = 0
		self.time_step       = 0
		self.time_adapt      = 0
		self.cfl_coefficient = 0
		
		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(self):
		# {{{ Display
		string="   timestepping parameters:"
		string="%s\n\n%s"%(string,fielddisplay(self,"start_time","simulation starting time [yrs]"))
		string="%s\n%s"%(string,fielddisplay(self,"final_time","final time to stop the simulation [yrs]"))
		string="%s\n%s"%(string,fielddisplay(self,"time_step","length of time steps [yrs]"))
		string="%s\n%s"%(string,fielddisplay(self,"time_adapt","use cfl condition to define time step ? (0 or 1) "))
		string="%s\n%s"%(string,fielddisplay(self,"cfl_coefficient","coefficient applied to cfl condition"))
		return string
		#}}}
		
	def setdefaultparameters(self):
		# {{{setdefaultparameters
		
		#time between 2 time steps
		self.time_step=1/2

		#final time
		self.final_time=10*self.time_step

		#time adaptation? 
		self.time_adapt=0
		self.cfl_coefficient=.5

		return self
	#}}}

	def checkconsistency(self,md,solution,analyses):    # {{{

		md = checkfield(md,'timestepping.start_time','numel',[1],'NaN',1)
		md = checkfield(md,'timestepping.final_time','numel',[1],'NaN',1)
		md = checkfield(md,'timestepping.time_step','numel',[1],'>=',0,'NaN',1)
		md = checkfield(md,'timestepping.time_adapt','numel',[1],'values',[0,1])
		md = checkfield(md,'timestepping.cfl_coefficient','numel',[1],'>',0,'<=',1)
		if self.final_time-self.start_time<0:
			md.checkmessage("timestepping.final_time should be larger than timestepping.start_time")

		return md
	# }}}

	def marshall(self,fid):    # {{{
		WriteData(fid,'object',self,'fieldname','start_time','format','Double')
		WriteData(fid,'object',self,'fieldname','final_time','format','Double')
		WriteData(fid,'object',self,'fieldname','time_step','format','Double')
		WriteData(fid,'object',self,'fieldname','time_adapt','format','Boolean')
		WriteData(fid,'object',self,'fieldname','cfl_coefficient','format','Double')
	# }}}

