#module imports
from fielddisplay import fielddisplay
from EnumDefinitions import *
from checkfield import *
from WriteData import *

class surfaceforcings(object):
	"""
	SURFACEFORCING Class definition

	   Usage:
	      surfaceforcings=surfaceforcings();
	"""

	#properties
	def __init__(self):
		# {{{ Properties
		self.precipitation = float('NaN')
		self.mass_balance  = float('NaN')
		self.ispdd = 0
		self.issmbgradients = 0
		self.isdelta18o = 0
		self.hc = float('NaN')
		self.smb_pos_max = float('NaN')
		self.smb_pos_min = float('NaN')
		self.a_pos = float('NaN')
		self.b_pos = float('NaN')
		self.a_neg = float('NaN')
		self.b_neg = float('NaN')
		self.monthlytemperatures = float('NaN')
		self.delta18o = float('NaN')
		self.delta18o_surface = float('NaN')
		self.temperatures_presentday = float('NaN')
		self.temperatures_lgm = float('NaN')
		self.precipitations_presentday = float('NaN')

		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(self):
		# {{{ Display
		string="   surface forcings parameters:"

		string="%s\n\n%s"%(string,fielddisplay(self,'precipitation','surface precipitation [m/yr water eq]'))
		string="%s\n%s"%(string,fielddisplay(self,'mass_balance','surface mass balance [m/yr ice eq]'))
		string="%s\n%s"%(string,fielddisplay(self,'ispdd','is pdd activated (0 or 1, default is 0)'))
		string="%s\n%s"%(string,fielddisplay(self,'isdelta18o','is temperature and precipitation delta18o parametrisation activated (0 or 1, default is 0)'))
		string="%s\n%s"%(string,fielddisplay(self,'monthlytemperatures','monthly surface temperatures [Kelvin], required if pdd is activated and delta18o not activated'))
		string="%s\n%s"%(string,fielddisplay(self,'precipitation','surface precipitation [m/yr water eq]'))
		string="%s\n%s"%(string,fielddisplay(self,'temperatures_presentday','monthly present day surface temperatures [Kelvin], required if pdd is activated and delta18o activated'))
		string="%s\n%s"%(string,fielddisplay(self,'temperatures_lgm','monthly LGM surface temperatures [Kelvin], required if pdd is activated and delta18o activated'))
		string="%s\n%s"%(string,fielddisplay(self,'precipitations_presentday','monthly surface precipitation [m/yr water eq], required if pdd is activated and delta18o activated'))
		string="%s\n%s"%(string,fielddisplay(self,'delta18o','delta18o, required if pdd is activated and delta18o activated'))
		string="%s\n%s"%(string,fielddisplay(self,'delta18o_surface','surface elevation of the delta18o site, required if pdd is activated and delta18o activated'))
		string="%s\n%s"%(string,fielddisplay(self,'issmbgradients','is smb gradients method activated (0 or 1, default is 0)'))
		string="%s\n%s"%(string,fielddisplay(self,'hc',' elevation of intersection between accumulation and ablation regime required if smb gradients is activated'))
		string="%s\n%s"%(string,fielddisplay(self,'smb_pos_max',' maximum value of positive smb required if smb gradients is activated'))
		string="%s\n%s"%(string,fielddisplay(self,'smb_pos_min',' minimum value of positive smb required if smb gradients is activated'))
		string="%s\n%s"%(string,fielddisplay(self,'a_pos',' intercept of hs - smb regression line for accumulation regime required if smb gradients is activated'))
		string="%s\n%s"%(string,fielddisplay(self,'b_pos',' slope of hs - smb regression line for accumulation regime required if smb gradients is activated'))
		string="%s\n%s"%(string,fielddisplay(self,'a_neg',' intercept of hs - smb regression line for ablation regime required if smb gradients is activated'))
		string="%s\n%s"%(string,fielddisplay(self,'b_neg',' slope of hs - smb regression line for ablation regime required if smb gradients is activated'))

		return string
		#}}}
		
	def setdefaultparameters(self):
		# {{{setdefaultparameters
		  
		#pdd method not used in default mode
		self.ispdd=0
		self.issmbgradients=0
		self.isdelta18o=0

		return self
	#}}}

	def checkconsistency(self,md,solution,analyses):    # {{{

		if PrognosticAnalysisEnum() in analyses:
			md = checkfield(md,'surfaceforcings.ispdd','numel',[1],'values',[0,1])
			md = checkfield(md,'surfaceforcings.issmbgradients','numel',[1],'values',[0,1])
			if   self.ispdd:
				if not self.isdelta18o:
					md = checkfield(md,'surfaceforcings.monthlytemperatures','forcing',1,'NaN',1)
					md = checkfield(md,'surfaceforcings.precipitation','forcing',1,'NaN',1)
				else:
					md = checkfield(md,'surfaceforcings.delta18o','NaN',1)
					md = checkfield(md,'surfaceforcings.delta18o_surface','NaN',1)
					md = checkfield(md,'surfaceforcings.temperatures_presentday','size',[md.mesh.numberofvertices+1,12],'NaN',1)
					md = checkfield(md,'surfaceforcings.temperatures_lgm','size',[md.mesh.numberofvertices+1,12],'NaN',1)
					md = checkfield(md,'surfaceforcings.precipitations_presentday','size',[md.mesh.numberofvertices+1,12],'NaN',1)
			elif self.issmbgradients:
				md = checkfield(md,'surfaceforcings.hc','forcing',1,'NaN',1)
				md = checkfield(md,'surfaceforcings.smb_pos_max','forcing',1,'NaN',1)
				md = checkfield(md,'surfaceforcings.smb_pos_min','forcing',1,'NaN',1)
				md = checkfield(md,'surfaceforcings.a_pos','forcing',1,'NaN',1)
				md = checkfield(md,'surfaceforcings.b_pos','forcing',1,'NaN',1)
				md = checkfield(md,'surfaceforcings.a_neg','forcing',1,'NaN',1)
				md = checkfield(md,'surfaceforcings.b_neg','forcing',1,'NaN',1)
			else:
				md = checkfield(md,'surfaceforcings.mass_balance','forcing',1,'NaN',1)

		if BalancethicknessAnalysisEnum() in analyses:
			md = checkfield(md,'surfaceforcings.mass_balance','size',[md.mesh.numberofvertices],'NaN',1)

		return md
	# }}}

	def marshall(self,fid):    # {{{
		WriteData(fid,'object',self,'fieldname','precipitation','format','DoubleMat','mattype',1)
		WriteData(fid,'object',self,'fieldname','mass_balance','format','DoubleMat','mattype',1)
		WriteData(fid,'object',self,'fieldname','ispdd','format','Boolean')
		WriteData(fid,'object',self,'fieldname','isdelta18o','format','Boolean')

		if self.ispdd:
			if self.isdelta18o:
				WriteData(fid,'object',self,'fieldname','temperatures_presentday','format','DoubleMat','mattype',1)
				WriteData(fid,'object',self,'fieldname','temperatures_lgm','format','DoubleMat','mattype',1)
				WriteData(fid,'object',self,'fieldname','precipitations_presentday','format','DoubleMat','mattype',1)
				WriteData(fid,'object',self,'fieldname','delta18o_surface','format','DoubleMat','mattype',1)
				WriteData(fid,'object',self,'fieldname','delta18o','format','DoubleMat','mattype',1)
			else:
				WriteData(fid,'object',self,'fieldname','monthlytemperatures','format','DoubleMat','mattype',1)
				WriteData(fid,'object',self,'fieldname','precipitation','format','DoubleMat','mattype',1)

		WriteData(fid,'object',self,'fieldname','issmbgradients','format','Boolean')

		if self.issmbgradients:
			WriteData(fid,'object',self,'fieldname','hc','format','DoubleMat','mattype',1)
			WriteData(fid,'object',self,'fieldname','smb_pos_max','format','DoubleMat','mattype',1)
			WriteData(fid,'object',self,'fieldname','smb_pos_min','format','DoubleMat','mattype',1)
			WriteData(fid,'object',self,'fieldname','a_pos','format','DoubleMat','mattype',1)
			WriteData(fid,'object',self,'fieldname','b_pos','format','DoubleMat','mattype',1)
			WriteData(fid,'object',self,'fieldname','a_neg','format','DoubleMat','mattype',1)
			WriteData(fid,'object',self,'fieldname','b_neg','format','DoubleMat','mattype',1)
	# }}}

