%SURFACEFORCING Class definition
%
%   Usage:
%      surfaceforcings=surfaceforcings();

classdef surfaceforcings
	properties (SetAccess=public) 
		precipitation = NaN;
		mass_balance  = NaN;
		ispdd = 0;
		issmbgradients = 0;
		isdelta18o = 0;
		hc = NaN;
		smb_pos_max = NaN;
		smb_pos_min = NaN;
		a_pos = NaN;
		b_pos = NaN;
		a_neg = NaN;
		b_neg = NaN;
		monthlytemperatures = NaN;
		delta18o = NaN;
		delta18o_surface = NaN;
		temperatures_presentday = NaN;
		temperatures_lgm = NaN;
		precipitations_presentday = NaN;
	end
	methods
		function obj = surfaceforcings(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{
		  
		  %pdd method not used in default mode
		  obj.ispdd=0;
		  obj.issmbgradients=0;
		  obj.isdelta18o=0;

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			if ismember(PrognosticAnalysisEnum(),analyses),
				md = checkfield(md,'surfaceforcings.ispdd','numel',[1],'values',[0 1]);
				md = checkfield(md,'surfaceforcings.issmbgradients','numel',[1],'values',[0 1]);
				if(obj.ispdd)
					if(obj.isdelta18o==0)
						md = checkfield(md,'surfaceforcings.monthlytemperatures','forcing',1,'NaN',1);
						md = checkfield(md,'surfaceforcings.precipitation','forcing',1,'NaN',1);
					else
						md = checkfield(md,'surfaceforcings.delta18o','NaN',1);
						md = checkfield(md,'surfaceforcings.delta18o_surface','NaN',1);
						md = checkfield(md,'surfaceforcings.temperatures_presentday','size',[md.mesh.numberofvertices+1 12],'NaN',1);
						md = checkfield(md,'surfaceforcings.temperatures_lgm','size',[md.mesh.numberofvertices+1 12],'NaN',1);
						md = checkfield(md,'surfaceforcings.precipitations_presentday','size',[md.mesh.numberofvertices+1 12],'NaN',1);
					end
				elseif(obj.issmbgradients)
					md = checkfield(md,'surfaceforcings.hc','forcing',1,'NaN',1);
					md = checkfield(md,'surfaceforcings.smb_pos_max','forcing',1,'NaN',1);
					md = checkfield(md,'surfaceforcings.smb_pos_min','forcing',1,'NaN',1);
					md = checkfield(md,'surfaceforcings.a_pos','forcing',1,'NaN',1);
					md = checkfield(md,'surfaceforcings.b_pos','forcing',1,'NaN',1);
					md = checkfield(md,'surfaceforcings.a_neg','forcing',1,'NaN',1);
					md = checkfield(md,'surfaceforcings.b_neg','forcing',1,'NaN',1);
				else
					md = checkfield(md,'surfaceforcings.mass_balance','forcing',1,'NaN',1);
				end
			end
			if ismember(BalancethicknessAnalysisEnum(),analyses),
				md = checkfield(md,'surfaceforcings.mass_balance','size',[md.mesh.numberofvertices 1],'NaN',1);
			end
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   surface forcings parameters:'));

			fielddisplay(obj,'mass_balance','surface mass balance [m/yr ice eq]');
			fielddisplay(obj,'ispdd','is pdd activated (0 or 1, default is 0)');
			fielddisplay(obj,'isdelta18o','is temperature and precipitation delta18o parametrisation activated (0 or 1, default is 0)');
			fielddisplay(obj,'monthlytemperatures','monthly surface temperatures [Kelvin], required if pdd is activated and delta18o not activated');
			fielddisplay(obj,'precipitation','surface precipitation [m/yr water eq]');
			fielddisplay(obj,'temperatures_presentday','monthly present day surface temperatures [Kelvin], required if pdd is activated and delta18o activated');
			fielddisplay(obj,'temperatures_lgm','monthly LGM surface temperatures [Kelvin], required if pdd is activated and delta18o activated');
			fielddisplay(obj,'precipitations_presentday','monthly surface precipitation [m/yr water eq], required if pdd is activated and delta18o activated');
			fielddisplay(obj,'delta18o','delta18o, required if pdd is activated and delta18o activated');
			fielddisplay(obj,'delta18o_surface','surface elevation of the delta18o site, required if pdd is activated and delta18o activated');
			fielddisplay(obj,'issmbgradients','is smb gradients method activated (0 or 1, default is 0)');
			fielddisplay(obj,'hc',' elevation of intersection between accumulation and ablation regime required if smb gradients is activated');
			fielddisplay(obj,'smb_pos_max',' maximum value of positive smb required if smb gradients is activated');
			fielddisplay(obj,'smb_pos_min',' minimum value of positive smb required if smb gradients is activated');
			fielddisplay(obj,'a_pos',' intercept of hs - smb regression line for accumulation regime required if smb gradients is activated');
			fielddisplay(obj,'b_pos',' slope of hs - smb regression line for accumulation regime required if smb gradients is activated');
			fielddisplay(obj,'a_neg',' intercept of hs - smb regression line for ablation regime required if smb gradients is activated');
			fielddisplay(obj,'b_neg',' slope of hs - smb regression line for ablation regime required if smb gradients is activated');

		end % }}}
		function marshall(obj,fid) % {{{
			WriteData(fid,'object',obj,'fieldname','precipitation','format','DoubleMat','mattype',1);
			WriteData(fid,'object',obj,'fieldname','mass_balance','format','DoubleMat','mattype',1);
			WriteData(fid,'object',obj,'fieldname','ispdd','format','Boolean');
			WriteData(fid,'object',obj,'fieldname','isdelta18o','format','Boolean');
			if obj.ispdd,
				if obj.isdelta18o
					WriteData(fid,'object',obj,'fieldname','temperatures_presentday','format','DoubleMat','mattype',1);
					WriteData(fid,'object',obj,'fieldname','temperatures_lgm','format','DoubleMat','mattype',1);
					WriteData(fid,'object',obj,'fieldname','precipitations_presentday','format','DoubleMat','mattype',1);
					WriteData(fid,'object',obj,'fieldname','delta18o_surface','format','DoubleMat','mattype',1);
					WriteData(fid,'object',obj,'fieldname','delta18o','format','DoubleMat','mattype',1);
				else
					WriteData(fid,'object',obj,'fieldname','monthlytemperatures','format','DoubleMat','mattype',1);
					WriteData(fid,'object',obj,'fieldname','precipitation','format','DoubleMat','mattype',1);
				end
			end
			WriteData(fid,'object',obj,'fieldname','issmbgradients','format','Boolean');
			if obj.issmbgradients,
				WriteData(fid,'object',obj,'fieldname','hc','format','DoubleMat','mattype',1);
				WriteData(fid,'object',obj,'fieldname','smb_pos_max','format','DoubleMat','mattype',1);
				WriteData(fid,'object',obj,'fieldname','smb_pos_min','format','DoubleMat','mattype',1);
				WriteData(fid,'object',obj,'fieldname','a_pos','format','DoubleMat','mattype',1);
				WriteData(fid,'object',obj,'fieldname','b_pos','format','DoubleMat','mattype',1);
				WriteData(fid,'object',obj,'fieldname','a_neg','format','DoubleMat','mattype',1);
				WriteData(fid,'object',obj,'fieldname','b_neg','format','DoubleMat','mattype',1);
			end

		end % }}}
	end
end
