#module imports
from fielddisplay import fielddisplay
from EnumDefinitions import *
from checkfield import *
from WriteData import *

class basalforcings(object):
	"""
	BASAL FORCINGS class definition

	   Usage:
	      basalforcings=basalforcings();
	"""

	#properties
	def __init__(self):
		# {{{ Properties
		self.melting_rate             = float('NaN')
		self.melting_rate_correction  = float('NaN')
		self.geothermalflux           = float('NaN')

		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(self):
		# {{{ Display
		string="   basal forcings parameters:"

		string="%s\n\n%s"%(string,fielddisplay(self,"melting_rate","basal melting rate (positive if melting)"))
		string="%s\n%s"%(string,fielddisplay(self,"melting_rate_correction","additional melting applied when the grounding line retreats"))
		string="%s\n%s"%(string,fielddisplay(self,"geothermalflux","geothermal heat flux [W/m^2]"))
		return string
		#}}}
	def setdefaultparameters(self):
		# {{{setdefaultparameters
		return self
	#}}}

	def checkconsistency(self,md,solution,analyses):    # {{{

		if PrognosticAnalysisEnum() in analyses and not (solution==TransientSolutionEnum() and not md.transient.isprognostic):
			md = checkfield(md,'basalforcings.melting_rate','NaN',1,'forcing',1)

		if BalancethicknessAnalysisEnum() in analyses:
			md = checkfield(md,'basalforcings.melting_rate','NaN',1,'size',[md.mesh.numberofvertices])

		if ThermalAnalysisEnum() in analyses and not (solution==TransientSolutionEnum() and not md.transient.isthermal):
			md = checkfield(md,'basalforcings.melting_rate','NaN',1,'forcing',1)
			md = checkfield(md,'basalforcings.geothermalflux','NaN',1,'forcing',1,'>=',0)

		return md
	# }}}

	def marshall(self,fid):    # {{{
		WriteData(fid,'object',self,'fieldname','melting_rate','format','DoubleMat','mattype',1)
		WriteData(fid,'object',self,'fieldname','melting_rate_correction','format','DoubleMat','mattype',1)
		WriteData(fid,'object',self,'fieldname','geothermalflux','format','DoubleMat','mattype',1)
	# }}}

