/*!\file:  DomainOutlineWrite.cpp
 * \brief DomainOutlineWrite.c: write the vertex coordinates defined in a domain 
 * outline from Argus (.exp file). The first contour in the file is for 
 * the outside domain outline. The following contours represent holes in
 * the domain.
 */

#include <stdio.h>
#include "../Alloc/alloc.h"
#include "../../include/include.h"
#include "../Exceptions/exceptions.h"

int DomainOutlineWrite(int nprof,int* profnvertices,double** pprofx,double** pprofy,bool* closed,char* domainname){

	
	/*Error management: */
	int noerr=1;
	int i,counter;

	/*I/O: */
	FILE* fid=NULL;

	/*open domain outline file for writing: */
	if ((fid=fopen(domainname,"w"))==NULL){
		_error_("could not open domain file " << domainname); 
		noerr=0; goto cleanupandreturn;
	}

	/*Start writing profiles: */
	for(counter=0;counter<nprof;counter++){

		/*Write header: */
		fprintf(fid,"%s %s\n","##","Name:");
		fprintf(fid,"%s %s\n","##","Icon:0");
		fprintf(fid,"%s %s %s %s\n","#","Points","Count","Value");
		
		/*Write number of profile vertices: */
		fprintf(fid,"%u %s\n",profnvertices[counter]  ,"1.");
	
		/*Write next line: */
		fprintf(fid,"%s %s %s %s %s\n","#","X","pos","Y","pos");

		/*Write vertices: */
		for (i=0;i<profnvertices[counter];i++){
			fprintf(fid,"%lf\t%lf\n",pprofx[counter][i],pprofy[counter][i]);
		}

		/*Write blank line: */
		if(counter < nprof-1) fprintf(fid,"\n");
	}

	/*close domain outline file: */
	fclose(fid);

	cleanupandreturn: 
	return noerr;
}

