#!/bin/bash
#Step 0: download
#Step 1: install and write script
STEP=0

if [ $STEP -eq 0 ]; then
	# Adapted from petsc 3.2. 
	# Used Mercurial to get code
	rm -rf src
	hg clone http://petsc.cs.iit.edu/petsc/petsc-dev src
	cd src
	hg clone http://petsc.cs.iit.edu/petsc/BuildSystem config/BuildSystem
fi

# To update (via Mercurial):
#      cd petsc-dev
#      hg pull -u
#      cd config/BuildSystem
#      hg pull -u

# configure script
# Note: using metis from externalpackages did not work...
# for now downloading new metis
#   -then rename metis in externalpackages to metis2
if [ $STEP -eq 1 ]; then

	mkdir install

	#configure
	cd src
	./config/configure.py \
		--prefix="$ISSM_DIR/externalpackages/petsc/install" \
		--with-batch=1  \
		--PETSC_ARCH="$ISSM_ARCH" \
		--PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
		--with-debugging=0 \
		--with-shared-libraries=0 \
		--with-blas-lapack-dir=/nasa/intel/mkl/10.0.011/ \
		--known-mpi-shared-libraries=1 \
		--with-mpi-lib=/nasa/sgi/mpt/2.04/lib/libmpi.so \
		--with-mpi-include=/nasa/sgi/mpt/2.04/include  \
		--download-mumps=yes \
		--download-plapack=yes \
		--download-scalapack=yes \
		--download-blacs=yes  \
		--download-blas=yes \
		--download-f-blas-lapack=yes \
		--download-parmetis=yes \
		--download-metis=yes \
		--download-trilinos=yes \
		--download-euclid=yes \
		--download-pastix=yes \
		--download-ptscotch=yes \
		--download-spooles=yes \
		--download-spai=yes \
		--download-superlu=yes \
		--download-hypre=yes \
		--download-prometheus=yes \
		--FFLAGS=-I/usr/include \
		--with-cxx=icpc \
		--with-cc=icc \
		--with-fc=ifort \
		--COPTFLAGS=" -O3 -xS" \
		--FOPTFLAGS=" -O3 -xS" \
		--CXXOPTFLAGS=" -O3 -xS" \
		--with-pic=1
		cat > script.queue << EOF
#PBS -S /bin/bash
#PBS -q debug 
#PBS -l select=1:ncpus=1:model=har 
#PBS -l walltime=200 
#PBS -W group_list=s1010 
#PBS -m e 
. /usr/share/modules/init/bash 
module load comp-intel/11.1.046 
module load mpi-sgi/mpt.2.04  #DEFINES MPI_Type_create_indexed_block
module load math/intel_mkl_64_10.0.011 
export PATH="$PATH:." 
export MPI_GROUP_MAX=64 
mpiexec -np 1 ./conftest-linux-gnu-ia64-intel.py
EOF
	echo "== Follow PETSc's instructions"
fi
