#Module import 
from math import isnan


def fielddisplay(md,name,comment):
#FIELDDISPLAY - display model field
#
#   Usage:
#      fielddisplay(md,name,comment)

	#get field
	field=getattr(md,name)

	#disp corresponding line as a function of field type (offset set as 9 spaces)
	return parsedisplay("         ",name,field,comment);

#parsedisplay{{{ 
def  parsedisplay(offset,name,field,comment):

	#string
	if isinstance(field,(str,unicode)):
		if len(field)>30:
			string=displayunit(offset,name,"not displayed",comment)
		else:
			string=displayunit(offset,name,field,comment)

	#numeric
	elif isinstance(field, (int,long)):
		string=displayunit(offset,name,"%i" % (field),comment) 

	elif isinstance(field, complex):
		raise RuntimeError("fielddisplay cannot handle complex numbers")

	elif isinstance(field, float):
		string=displayunit(offset,name,"%g"%(field),comment)

	#logical
	elif isinstance(field,bool):
		if field:
			string=displayunit(offset,name,"true",comment)
		else:
			string=displayunit(offset,name,"false",comment)
	
	elif isinstance(field,dict):
		if not field:
			string=displayunit(offset,name,'N/A',comment)
		else:
			string=displayunit(offset,name,'(dictionary)',comment)
			for key in field.keys():
				string="%s\n%s"%(string,parsedisplay(offset + '   ',key,field[key],''))

	elif isinstance(field,list):
		if not field:
			string=displayunit(offset,name,'N/A',comment),
		else:
			string=displayunit(offset,name,'(structure)',comment)
			for i in range(len(field)):
				string="%s\n%s"%(string,displayunit(offset + '   ',name,field[i],comment))
	#cell
	#elif  iscell(field):
	#	cell_display(offset,name,field,comment),

	else:
		string=displayunit(offset,name,"not displayed",comment)
		
	return string

#}}}
#displayunit {{{
def  displayunit(offset,name,characterization,comment):

	#take care of name
	if len(name)>23:
		name="%s..." % (name[:19])
	
	#take care of characterization
	if characterization=="":
		characterization="N/A"
	
	if characterization=="nan":
		characterization="N/A"
	
	if len(characterization)>15:
		characterization="%s%s" % (characterization[:11],"...")
	
	#print
	if not comment:
		string="%s%-23s: %-15s" % (offset,name,characterization)
	else:
		if isinstance(comment,(str,unicode)):
			string="%s%-23s: %-15s -- %s" % (offset,name,characterization,comment)
		elif isinstance(comment,list):
			print(comment)
			string="%s%-23s: %-15s -- %s" % (offset,name,characterization,comment[0])
			for i in range(1,len(comment)):
				string2="%s%-23s  %-15s    %s" %(offset,"","",comment[i])
				string="%s\n%s"%(string,string2)
		else:
			raise RuntimeError("fielddisplay error message: format for comment not supportet yet")

	return string
#}}}
