/*! \file TriaP1Input.h 
 *  \brief: header file for TriaP1Input object
 */


#ifndef _TRIAP1INPUT_H_
#define _TRIAP1INPUT_H_

/*Headers:*/
/*{{{*/
#include "./Input.h"
#include "../Elements/TriaRef.h"
class GaussTria;
/*}}}*/

class TriaP1Input: public Input,public TriaRef{

	public:
		/*just hold 3 values for 3 vertices: */
		int    enum_type;
		IssmDouble values[3];

		/*TriaP1Input constructors, destructors: {{{*/
		TriaP1Input();
		TriaP1Input(int enum_type,IssmDouble* values);
		~TriaP1Input();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*TriaP1Input management: {{{*/
		int   InstanceEnum();
		Input* SpawnTriaInput(int* indices);
		Input* PointwiseDivide(Input* inputB){_error_("not implemented yet");};
		Input* PointwiseMin(Input* inputB);
		Input* PointwiseMax(Input* inputB);
		ElementResult* SpawnResult(int step, IssmDouble time);
		void AddTimeValues(IssmDouble* values,int step,IssmDouble time){_error_("not supported yet");};
		void Configure(Parameters* parameters);
		/*}}}*/
		/*numerics: {{{*/
		void GetInputValue(bool* pvalue){_error_("not implemented yet");}
		void GetInputValue(int* pvalue){_error_("not implemented yet");}
		void GetInputValue(IssmDouble* pvalue){_error_("not implemented yet");}
		void GetInputValue(IssmDouble* pvalue,GaussTria* gauss);
		void GetInputValue(IssmDouble* pvalue,GaussPenta* gauss){_error_("not implemented yet");};
		void GetInputValue(IssmDouble* pvalue,GaussTria* gauss,IssmDouble time){_error_("not implemented yet");};
		void GetInputValue(IssmDouble* pvalue,GaussPenta* gauss,IssmDouble time){_error_("not implemented yet");};
		void GetInputValue(IssmDouble* pvalue,GaussTria* gauss ,int index){_error_("not implemented yet");};
		void GetInputValue(IssmDouble* pvalue,GaussPenta* gauss,int index){_error_("not implemented yet");};
		void GetInputDerivativeValue(IssmDouble* derivativevalues, IssmDouble* xyz_list, GaussTria* gauss);
		void GetInputDerivativeValue(IssmDouble* derivativevalues, IssmDouble* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetInputAverage(IssmDouble* pvalue);
		void GetVxStrainRate2d(IssmDouble* epsilonvx,IssmDouble* xyz_list, GaussTria* gauss);
		void GetVyStrainRate2d(IssmDouble* epsilonvy,IssmDouble* xyz_list, GaussTria* gauss);
		void GetVxStrainRate3d(IssmDouble* epsilonvx,IssmDouble* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVyStrainRate3d(IssmDouble* epsilonvy,IssmDouble* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVzStrainRate3d(IssmDouble* epsilonvz,IssmDouble* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVxStrainRate3dPattyn(IssmDouble* epsilonvx,IssmDouble* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVyStrainRate3dPattyn(IssmDouble* epsilonvy,IssmDouble* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void ChangeEnum(int newenumtype);

		void SquareMin(IssmDouble* psquaremin, bool process_units,Parameters* parameters);
		void ConstrainMin(IssmDouble minimum);
		void Scale(IssmDouble scale_factor);
		void ArtificialNoise(IssmDouble min,IssmDouble max);
		void AXPY(Input* xinput,IssmDouble scalar);
		void Constrain(IssmDouble cm_min, IssmDouble cm_max);
		IssmDouble InfinityNorm(void);
		IssmDouble Max(void);
		IssmDouble MaxAbs(void);
		IssmDouble Min(void);
		IssmDouble MinAbs(void);
		void Extrude(void){_error_("not supported yet");};
		void VerticallyIntegrate(Input* thickness_input){_error_("not supported yet");};
		void GetVectorFromInputs(Vector* vector,int* doflist);
		void GetValuesPtr(IssmDouble** pvalues,int* pnum_values);
		/*}}}*/

};
#endif  /* _TRIAP1INPUT_H */
