/*!\file CheckNumPythonArguments.cpp:
 * \brief: check number of arguments and report an usage error message.
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif


#define PY_ARRAY_UNIQUE_SYMBOL PythonIOSymbol
#define NO_IMPORT

#include "../../toolkits/toolkits.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../include/include.h"

int CheckNumPythonArguments(PyObject* inputs,int NRHS, void (*function)( void )){

	Py_ssize_t size=0;

	/*figure out size of tuple in input: */
	size=PyTuple_Size(inputs);
	
	/*check on requested size: */
	if (size==0){
		function();
		_error2_("usage: see above");
	}
	else if (size!=NRHS ) {
		function(); 
		_error2_("usage error.");
	}
	return 1;
}
