/*! \file DatasetInput.h 
 *  \brief: header file for datasetinput object
 */


#ifndef _DATASETINPUT_H_
#define _DATASETINPUT_H_

/*Headers:*/
/*{{{*/
#include "./Input.h"
#include "../../../include/include.h"
class GaussTria;
/*}}}*/

class DatasetInput: public Input{

	public:
		int    enum_type;

		Inputs*     inputs;

		/*DatasetInput constructors, destructors: {{{*/
		DatasetInput();
		DatasetInput(int enum_type);
		~DatasetInput();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id();
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*DatasetInput management: {{{*/
		int    InstanceEnum();
		Input* SpawnTriaInput(int* indices);
		Input* PointwiseDivide(Input* inputB){_error2_("not implemented yet");};
		Input* PointwiseMin(Input* inputB){_error2_("not implemented yet");};
		Input* PointwiseMax(Input* inputB){_error2_("not implemented yet");};
		ElementResult* SpawnResult(int step, IssmDouble time){_error2_("not implemented yet");};
		void AddTimeValues(IssmDouble* values,int step,IssmDouble time){_error2_("not supported yet");};
		void Configure(Parameters* parameters);
		/*}}}*/
		/*numerics: {{{*/
		void GetInputValue(bool* pvalue){_error2_("not implemented yet");};
		void GetInputValue(int* pvalue){_error2_("not implemented yet");};
		void GetInputValue(IssmDouble* pvalue){_error2_("not implemented yet");};
		void GetInputValue(IssmDouble* pvalue,GaussTria* gauss){_error2_("not implemented yet");};
		void GetInputValue(IssmDouble* pvalue,GaussPenta* gauss){_error2_("not implemented yet");};
		void GetInputValue(IssmDouble* pvalue,GaussTria* gauss,IssmDouble time){_error2_("not implemented yet");};
		void GetInputValue(IssmDouble* pvalue,GaussPenta* gauss,IssmDouble time){_error2_("not implemented yet");};
		void GetInputValue(IssmDouble* pvalue,GaussTria* gauss ,int index);
		void GetInputValue(IssmDouble* pvalue,GaussPenta* gauss ,int index){_error2_("not implemented yet");};
		void GetInputDerivativeValue(IssmDouble* derivativevalues, IssmDouble* xyz_list, GaussTria* gauss){_error2_("not implemented yet");};
		void GetInputDerivativeValue(IssmDouble* derivativevalues, IssmDouble* xyz_list, GaussPenta* gauss){_error2_("not implemented yet");};
		void GetInputAverage(IssmDouble* pvalue){_error2_("not implemented yet");};
		void GetVxStrainRate2d(IssmDouble* epsilonvx,IssmDouble* xyz_list, GaussTria* gauss){_error2_("not implemented yet");};
		void GetVyStrainRate2d(IssmDouble* epsilonvy,IssmDouble* xyz_list, GaussTria* gauss){_error2_("not implemented yet");};
		void GetVxStrainRate3d(IssmDouble* epsilonvx,IssmDouble* xyz_list, GaussPenta* gauss){_error2_("not implemented yet");};
		void GetVyStrainRate3d(IssmDouble* epsilonvy,IssmDouble* xyz_list, GaussPenta* gauss){_error2_("not implemented yet");};
		void GetVzStrainRate3d(IssmDouble* epsilonvz,IssmDouble* xyz_list, GaussPenta* gauss){_error2_("not implemented yet");};
		void GetVxStrainRate3dPattyn(IssmDouble* epsilonvx,IssmDouble* xyz_list, GaussPenta* gauss){_error2_("not implemented yet");};
		void GetVyStrainRate3dPattyn(IssmDouble* epsilonvy,IssmDouble* xyz_list, GaussPenta* gauss){_error2_("not implemented yet");};
		void ChangeEnum(int newenumtype){_error2_("not implemented yet");};
		void SquareMin(IssmDouble* psquaremin, bool process_units,Parameters* parameters){_error2_("not implemented yet");};
		void ConstrainMin(IssmDouble minimum){_error2_("not implemented yet");};
		void Scale(IssmDouble scale_factor){_error2_("not implemented yet");};
		void ArtificialNoise(IssmDouble min,IssmDouble max){_error2_("not implemented yet");};
		void AXPY(Input* xinput,IssmDouble scalar){_error2_("not implemented yet");};
		void Constrain(void){_error2_("not implemented yet");};
		void Constrain(IssmDouble min,IssmDouble max){_error2_("not implemented yet");};
		IssmDouble InfinityNorm(void){_error2_("not implemented yet");};
		IssmDouble Max(void){_error2_("not implemented yet");};
		IssmDouble MaxAbs(void){_error2_("not implemented yet");};
		IssmDouble Min(void){_error2_("not implemented yet");};
		IssmDouble MinAbs(void){_error2_("not implemented yet");};
		void Extrude(void){_error2_("not implemented yet");};
		void VerticallyIntegrate(Input* thickness_input){_error2_("not implemented yet");};
		void GetVectorFromInputs(Vector* vector,int* doflist){_error2_("not implemented yet");};
		void GetValuesPtr(IssmDouble** pvalues,int* pnum_values){_error2_("not implemented yet");};
		ElementResult* SpawnGradient(int step, IssmDouble time){_error2_("not implemented yet");};
		void GetGradient(Vector* gradient_vec,int* doflist){_error2_("not implemented yet");};
		void ScaleGradient(IssmDouble scale){_error2_("not implemented yet");};
		void SetGradient(Input* gradient_in){_error2_("not implemented yet");};
		void UpdateValue(IssmDouble scalar){_error2_("not implemented yet");};
		void SaveValue(void){_error2_("not implemented yet");};
		/*}}}*/

};
#endif  /* _DATASETINPUT_H */
