#ISSM_DIR and ISSM_ARCH should have been defined already in your shell settings file (.bashrc, .cshrc, etc ...)

#FIXME: during installation packages are installed one by one but environment.sh was sourced
#before so new packages are NOT in the path.
#may resource environment.sh with:
#if [ -z $(echo "$PATH" | grep "$MATLAB_DIR") ]; then export $PATH...; fi

#Windows compilers: 
if [[ "$ISSM_ARCH" == "cygwin-intel" ]]; then
	source $ISSM_DIR/externalpackages/windows/windows_environment.sh
fi

#Some basic path, in case it is not included by default
export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:/usr/local/lib"
export LD_RUN_PATH="$LD_RUN_PATH:/usr/local/lib"

#Load ISSM scripts
export PATH="$PATH:$ISSM_DIR/scripts"

#MATLAB
MATLAB_DIR="$ISSM_DIR/externalpackages/matlab/install"
#if [ -d "$MATLAB_DIR" ]; then
	export MATLAB_DIR
	export PATH="$MATLAB_DIR/bin:$PATH" #take precedence over /usr/local/bin/matlab
	export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$MATLAB_DIR/lib"
	export LD_RUN_PATH="$LD_RUN_PATH:$MATLAB_DIR/lib"
#fi

#MPI
MPI_DIR="$ISSM_DIR/externalpackages/mpich2/install"
#if [ -d "$MPI_DIR" ]; then
	export MPI_DIR
	export PATH="$MPI_DIR/bin:$PATH"
	export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$MPI_DIR/lib"
	export LD_RUN_PATH="$LD_RUN_PATH:$MPI_DIR/lib"
	export MANPATH="$MANPATH:$MPI_DIR/man"
#fi

#PETSC
PETSC_DIR="$ISSM_DIR/externalpackages/petsc/install"
#if [ -d "$PETSC_DIR" ]; then
	export PETSC_DIR
	export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$PETSC_DIR/lib:$PETSC_DIR/lib"
	export LD_RUN_PATH="$LD_RUN_PATH:$PETSC_DIR/lib"
#fi

#SLEPC
SLEPC_DIR="$ISSM_DIR/externalpackages/slepc/install"
if [ -d "$SLEPC_DIR" ]; then
	export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$SLEPC_DIR/lib/$ISSM_ARCH"
	export LD_RUN_PATH="$LD_RUN_PATH:$SLEPC_DIR/lib/$ISSM_ARCH"
fi

#PETSC
TAO_DIR="$ISSM_DIR/externalpackages/tao/install"
if [ -d "$TAO_DIR" ]; then
	export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$TAO_DIR/lib:$TAO_DIR/lib"
	export LD_RUN_PATH="$LD_RUN_PATH:$TAO_DIR/lib"
fi

#Dakota
DAKOTA_DIR="$ISSM_DIR/externalpackages/dakota/install"
if [ -d "$DAKOTA_DIR" ]; then
	export PATH="$PATH:$DAKOTA_DIR/bin"
	export MANPATH="$MANPATH:$MPI_DIR/man:$DAKOTA_DIR/docs/man:$DAKOTA_DIR/docs/man-ref"
fi

#Doxygen
DOXYGEN_DIR="$ISSM_DIR/externalpackages/doxygen/install"
if [ -d "$DOXYGEN_DIR" ]; then
	export MANPATH="$MANPATH:$DOXYGEN_DIR/man"
	export PATH="$PATH:$DOXYGEN_DIR/bin"
fi

#AUTOCONF
AUTOCONF_DIR="$ISSM_DIR/externalpackages/autoconf/install"
#if [ -d "$AUTOCONF_DIR" ]; then
	export PATH="$AUTOCONF_DIR/bin:$PATH"
#fi

#AUTOMAKE
AUTOMAKE_DIR="$ISSM_DIR/externalpackages/automake/install"
#if [ -d "$AUTOMAKE_DIR" ]; then
	export PATH="$AUTOMAKE_DIR/bin:$PATH"
#fi

#LIBTOOL
LIBTOOL_DIR="$ISSM_DIR/externalpackages/libtool/install"
#if [ -d "$LIBTOOL_DIR" ]; then
	export PATH="$LIBTOOL_DIR/bin:$PATH"
#fi

#SDK
SDK_DIR="C:/MicrosoftVisualStudio 9.0/Microsoft Visual C++ 2008 Express Edition with SP1 - ENU"
if [ -d "$SDK_DIR" ]; then
	export PATH="$PATH:$SDK_DIR"
fi

#SSH
SSH_DIR="$ISSM_DIR/externalpackages/ssh"
if [ -d "$SSH_DIR" ]; then
	export PATH="$PATH:$SSH_DIR"
fi

#VALGRIND
VALGRIND_DIR="$ISSM_DIR/externalpackages/valgrind/install"
if [ -d "$VALGRIND_DIR" ]; then
	export PATH="$VALGRIND_DIR/bin:$PATH"
fi

#CPPCHECK
CPPCHECK_DIR="$ISSM_DIR/externalpackages/cppcheck/install"
if [ -d "$CPPCHECK_DIR" ]; then
	export PATH="$PATH:$CPPCHECK_DIR/bin"
fi

#GDAL
GDAL_DIR="$ISSM_DIR/externalpackages/gdal/install"
if [ -d "$GDAL_DIR" ]; then
	export PATH="$GDAL_DIR/bin:$PATH"
	export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$GDAL_DIR/lib"
fi

#MERCURIAL
MERCURIAL_DIR="$ISSM_DIR/externalpackages/mercurial/install"
if [ -d "$MERCURIAL_DIR" ]; then
	export PYTHONPATH="$PYTHONPATH:$MERCURIAL_DIR/mercurial/pure/"
	export PATH="$PATH:$MERCURIAL_DIR/"
fi

#BOOST
BOOST_DIR="$ISSM_DIR/externalpackages/boost/install"
BOOSTROOT="$ISSM_DIR/externalpackages/boost/install"
if [ -d "$BOOST_DIR" ]; then
	export BOOSTROOT
	export BOOST_DIR
	export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$BOOST_DIR/lib"
	export DYLD_LIBRARY_PATH="$DYLD_LIBRARY_PATH:$BOOST_DIR/lib"
	export PATH="$PATH:$BOOST_DIR/bin"
fi

#XERCES
XERCESROOT="$ISSM_DIR/externalpackages/xerces/install"
XERCESCROOT="$ISSM_DIR/externalpackages/xerces/src"
if [ -d "$XERCESROOT" ]; then
	export XERCESROOT 
	export XERCESCROOT
fi

#xaifBooster
XAIF_DIR="$ISSM_DIR/externalpackages/xaifbooster/xaifBooster"
XAIFBOOSTERROOT="$ISSM_DIR/externalpackages/xaifbooster/"
XAIFBOOSTER_HOME="$ISSM_DIR/externalpackages/xaifbooster/xaifBooster"
PLATFORM="x86-Linux"
if [ -d "$XAIF_DIR" ]; then
	export XAIFBOOSTERROOT
	export XAIFBOOSTER_HOME
	export XAIF_DIR
	export PLATFORM
fi

#angel
ANGELROOT="$ISSM_DIR/externalpackages/angel/angel"
if [ -d "$ANGELROOT" ]; then
	export ANGELROOT
fi

#openanalysis
OPENANALYSISROOT="$ISSM_DIR/externalpackages/openanalysis/install"
if [ -d "$OPENANALYSISROOT" ]; then
	export OPENANALYSISROOT
	export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$OPENANALYSISROOT/lib"
fi

#JAVA
JVM_DIR="/usr/local/gcc/4.3.2/lib64/gcj-4.3.2-9/"
if [ -d "$JVM_DIR" ]; then
	export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$JVM_DIR"
fi

#BBFTP
BBFTP_DIR="$ISSM_DIR/externalpackages/bbftp/install"
if [ -d "$BBFTP_DIR" ]; then
	export PATH="$PATH:$BBFTP_DIR/bin"
fi

#ADIC
ADIC_DIR="$ISSM_DIR/externalpackages/adic/install"
if [ -d "$ADIC_DIR" ]; then
	export PATH="$PATH:$ADIC_DIR/bin"
	export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$ADIC_DIR/lib"
	export LD_RUN_PATH="$LD_RUN_PATH:$ADIC_DIR/lib"
fi

#COLPACK
COLPACK_DIR="$ISSM_DIR/externalpackages/colpack/install"
if [ -d "$COLPACK_DIR" ]; then
	export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$COLPACK_DIR/lib"
	export LD_RUN_PATH="$LD_RUN_PATH:$COLPACK_DIR/lib"
fi

#ECLIPSE
ECLIPSE_DIR="$ISSM_DIR/externalpackages/eclipse/install"
if [ -d "$ECLIPSE_DIR" ]; then
	export PATH="$PATH:$ECLIPSE_DIR"
fi

#APPSCAN
APPSCAN_DIR="$ISSM_DIR/externalpackages/appscan/install"
if [ -d "$APPSCAN_DIR" ]; then
	export PATH="$PATH:$APPSCAN_DIR/bin"
fi

#RATS
RATS_DIR="$ISSM_DIR/externalpackages/rats/install"
if [ -d "$RATS_DIR" ]; then
	export PATH="$PATH:$RATS_DIR/bin"
fi

#DYSON
DYSON_DIR="$ISSM_DIR/externalpackages/dyson/"
if [ -d "$DYSON_DIR" ]; then
	export PATH="$PATH:$DYSON_DIR"
fi

#CMAKE
CMAKE_DIR="$ISSM_DIR/externalpackages/cmake/install"
if [ -d "$CMAKE_DIR" ]; then
	export PATH="$PATH:$CMAKE_DIR/bin"
fi

#SHAPELIB
SHAPELIB_DIR="$ISSM_DIR/externalpackages/shapelib/install"
if [ -d "$SHAPELIB_DIR" ]; then
	export PATH="$PATH:$SHAPELIB_DIR/exec"
fi

#CCCL
CCCL_DIR="$ISSM_DIR/externalpackages/cccl/install"
if [ -d "$CCCL_DIR" ]; then
	export PATH="$PATH:$CCCL_DIR/bin"
fi

#PACKAGEMAKER
PACKAGEMAKER_DIR="$ISSM_DIR/externalpackages/packagemaker/install"
if [ -d "$PACKAGEMAKER_DIR" ]; then
	export PATH="$PATH:$PACKAGEMAKER_DIR"
fi

#ANDROID_NDK:
ANDROID_NDK_DIR="$ISSM_DIR/externalpackages/android-ndk/install"
if [ -d "$ANDROID_NDK_DIR" ]; then
	export PATH="$PATH:$ANDROID_NDK_DIR/"
fi

#ANDROID_SDK
ANDROID_SDK_DIR="$ANDROID_DIR/android-sdk/install-sdk"
if [ -d "$ANDROID_SDK_DIR" ]; then
	export PATH="$PATH:$ANDROID_SDK_DIR/"
fi

#GSL
GSL_DIR="$ISSM_DIR/externalpackages/gsl/install"
if [ -d "$GSL_DIR" ]; then
	export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$GSL_DIR/lib"
	export LD_RUN_PATH="$LD_RUN_PATH:$GSL_DIR/lib"
fi

#GMAKE
GMAKE_DIR="$ISSM_DIR/externalpackages/gmake/install"
if [ -d "$GMAKE_DIR" ]; then
	export PATH="$GMAKE_DIR/bin:$PATH"
fi

#PYTHON
PYTHON_DIR="$ISSM_DIR/externalpackages/python/install"
if [ -d "$PYTHON_DIR" ]; then
	PYTHONSTARTUP="$ISSM_DIR/startup.py"
	export PATH="$PYTHON_DIR/bin:$PATH"
	export PYTHONPATH="$PYTHONPATH:$ISSM_DIR/src/modules/python"
	export LD_LIBRARY_PATH=$ISSM_DIR/src/modules/python:$ISSM_DIR/externalpackages/python/install/lib:$LD_LIBRARY_PATH
	export PYTHONSTARTUP="$ISSM_DIR/startup.py"
fi

#MODELE
MODELE_DIR="$ISSM_DIR/externalpackages/modelE/install"
if [ -d "$MODELE_DIR" ]; then
	export PATH="$MODELE_DIR/src/exec:$PATH"
fi

#GIT
GIT_DIR="$ISSM_DIR/externalpackages/git/install"
if [ -d "$GIT_DIR" ]; then
	export PATH="$PATH:$GIT_DIR/bin"
fi

#NCVIEW
NCVIEW_DIR="$ISSM_DIR/externalpackages/ncview/install"
if [ -d "$NCVIEW_DIR" ]; then
	export PATH="$PATH:$NCVIEW_DIR"
fi

#TCLX
TCLX_DIR="$ISSM_DIR/externalpackages/tclx/install/lib/tclx8.4"
if [ -d "$TCLX_DIR" ]; then
	export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$TCLX_DIR"
	export LD_RUN_PATH="$LD_RUN_PATH:$TCLX_DIR"
fi

#ASPELL
ASPELL_DIR="$ISSM_DIR/externalpackages/aspell/install"
if [ -d "$ASPELL_DIR" ]; then
	export PATH="$ASPELL_DIR/bin:$PATH"
fi

#ESMF
ESMF_DIR="$ISSM_DIR/externalpackages/esmf/esmf"
if [ -d "$ESMF_DIR" ]; then
	export ESMF_COMPILER=gfortran
	export ESMF_COMM=mpich2
fi

#HDF5
HDF5_DIR="$ISSM_DIR/externalpackages/hdf5/install"
if [ -d "$HDF5_DIR" ]; then
	export DYLD_LIBRARY_PATH="$DYLD_LIBRARY_PATH:$HDF5_DIR/lib"
	export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$HDF5_DIR/lib"
	export LIBRARY_PATH="$LIBRARY_PATH:$HDF5_DIR/lib"
	export C_INCLUDE_PATH="$C_INCLUDE_PATH:$HDF5_DIR/include"
fi

#SVN
SVN_DIR="$ISSM_DIR/externalpackages/svn/install"
if [ -d "$SVN_DIR" ]; then
	export PATH="$SVN_DIR/bin:$PATH"
	export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$SVN_DIR/lib"
	export LIBRARY_PATH="$LIBRARY_PATH:$SVN_DIR/lib"
fi

#APR
APR_DIR="$ISSM_DIR/externalpackages/apr/install"
if [ -d "$APR_DIR" ]; then
	export PATH="$APR_DIR/bin:$PATH"
	export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$APR_DIR/lib"
	export LIBRARY_PATH="$LIBRARY_PATH:$APR_DIR/lib"
fi

#APR_UTIL
APR_UTIL_DIR="$ISSM_DIR/externalpackages/apr-util/install"
if [ -d "$APR_UTIL_DIR" ]; then
	export PATH="$APR_UTIL_DIR/bin:$PATH"
	export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$APR_UTIL_DIR/lib"
	export LIBRARY_PATH="$LIBRARY_PATH:$APR_UTIL_DIR/lib"
fi

#SQLITE
SQLITE_DIR="$ISSM_DIR/externalpackages/sqlite/install"
if [ -d "$SQLITE_DIR" ]; then
	export PATH="$SQLITE_DIR/bin:$PATH"
	export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$SQLITE_DIR/lib"
	export LIBRARY_PATH="$LIBRARY_PATH:$SQLITE_DIR/lib"
fi
