function structure=MatlabProcessPatch(structure);
%PROCESSPATCH - create a structure from a patch
%
%   Usage:
%      Result=ProcessPatch(Result);

%return if there is no field Patch
if (~isfield(structure,'Patch')),
	return;
end

%loop over steps
for i=1:length(structure),

	%Get Patch for current step
	Patch=structure(i).Patch;
	numvertices=structure(i).PatchVertices;

	%check that Patch is not empty
	if length(Patch)==0 continue; end

	%Get number of fields;
	fields=unique(Patch(:,1));
	steps=unique(Patch(:,2));

	%parse steps
	for j=1:length(steps),

		posstep=find(Patch(:,2)==steps(j));

		%Take all the lines of the Patch for this timestep
		temporarypatch=Patch(posstep,:);
		time=temporarypatch(1,3);
		step=temporarypatch(1,2);

		%parse fields
		for i=1:length(fields),

			%get name
			fieldname=EnumToString(fields(i));

			%get line positions
			pos=find(temporarypatch(:,1)==fields(i));

			%Fill Result structure
			structure(step).steps=step;
			structure(step).time=time;
			structure(step).(fieldname).element=temporarypatch(pos,4);
			structure(step).(fieldname).interpolation=temporarypatch(pos,5);
			structure(step).(fieldname).index=temporarypatch(pos,6:5+numvertices);
			if structure(step).(fieldname).interpolation==P1Enum(),
				structure(step).(fieldname).value=temporarypatch(pos,6+numvertices:end);
			end
			if structure(step).(fieldname).interpolation==P0Enum(),
				structure(step).(fieldname).value=temporarypatch(pos,6+numvertices);
			end

		end
	end
end

%remove fields
structure=rmfield(structure,'Patch');
structure=rmfield(structure,'PatchVertices');
structure=rmfield(structure,'PatchNodes');
