/*! \file OptionLogical.h 
 *  \brief: header file for optionlogical object
 */

#ifndef _OPTIONLOGICAL_H_
#define _OPTIONLOGICAL_H_

/*Headers:{{{*/
#include "../../../include/include.h"
#include "../../../shared/Exceptions/exceptions.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"

#include "./Option.h"
/*}}}*/

class OptionLogical: public Option {

	public:

		bool* values;

		/*OptionLogical constructors, destructors {{{*/
		OptionLogical();
		~OptionLogical();
		/*}}}*/
		/*Object virtual functions definitions:{{{*/
		void  Echo();
		void  DeepEcho();
		void  DeepEcho(char* indent);
		int   Id(){_error_("Not implemented yet");};
		int   MyRank(){_error_("Not implemented yet");};
		int   ObjectEnum(){return OptionLogicalEnum;};
		Object* copy(){_error_("Not implemented yet");};
		/*}}}*/

		/*virtual functions: */
		char* Name();
		int   NumEl();
		int   NDims();
		int*  Size();
		void  Get(int* pvalue){_error_("An OptionLogical object cannot return a int");};
		void  Get(IssmDouble* pvalue){_error_("An OptionLogical object cannot return a IssmDouble");};
		void  Get(bool* pvalue);
		void  Get(char** pvalue){ _error_("An OptionLogical object cannot return a string");};
		void  Get(char*** ppvalue,int *pnumel){ _error_("An OptionLogical object cannot return a string vec");};
		void  Get(IssmDouble** pvalue,int *pnumel){ _error_("An OptionLogical object cannot return a IssmDouble vec");};
		void  Get(Options** pvalue){ _error_("An OptionLogical object cannot return an Options DataSet");};
		void  Get(Options*** ppvalue,int *pnumel){ _error_("An OptionLogical object cannot return an Options DataSet vec");};

};
#endif  /* _OPTIONLOGICAL_H */

