/*! \file OptionDouble.h 
 *  \brief: header file for optionIssmDouble object
 */

#ifndef _OPTIONDOUBLE_H_
#define _OPTIONDOUBLE_H_

/*Headers:{{{*/
#include "../../../include/include.h"
#include "../../../shared/Exceptions/exceptions.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"

#include "./Option.h"
/*}}}*/

class OptionDouble: public Option {

	public:

		IssmDouble* values;

		/*OptionDouble constructors, destructors {{{*/
		OptionDouble();
		~OptionDouble();
		/*}}}*/
		/*Object virtual functions definitions:{{{*/
		void  Echo();
		void  DeepEcho();
		void  DeepEcho(char* indent);
		int   Id(){_error_("Not implemented yet");};
		int   MyRank(){_error_("Not implemented yet");};
		int   ObjectEnum(){return OptionDoubleEnum;};
		Object* copy(){_error_("Not implemented yet");};
		/*}}}*/

		/*virtual functions: */
		char* Name();
		int   NumEl();
		int   NDims();
		int*  Size();
		void  Get(int* pvalue);
		void  Get(IssmDouble* pvalue);
		void  Get(bool* pvalue){  _error_("An OptionDouble object cannot return a bool");};
		void  Get(char** pvalue){ _error_("An OptionDouble object cannot return a string");};
		void  Get(char*** ppvalue,int *pnumel){ _error_("An OptionDouble object cannot return a string vec");};
		void  Get(IssmDouble** pvalue,int* pnumel);
		void  Get(Options** pvalue){ _error_("An OptionDouble object cannot return an Options DataSet");};
		void  Get(Options*** ppvalue,int *pnumel){ _error_("An OptionDouble object cannot return an Options DataSet vec");};

};
#endif  /* _OPTIONDOUBLE_H */

