/*!\file:  StringToEnum.h
 * \brief header file for StringToEnum module.
 */ 

#ifndef _STRINGTOENUM_H
#define _STRINGTOENUM_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

/*Very important definition in case we are compiling a python module!: needs to come before header files inclusion*/
#ifdef _HAVE_PYTHON_
#define PY_ARRAY_UNIQUE_SYMBOL PythonIOSymbol
#endif

/*Header files: */
#include "../../c/include/globals.h"
#include "../../c/modules/modules.h"
#include "../../c/Container/Container.h"
#include "../../c/shared/shared.h"
#include "../../c/issm-binding.h"
    
#ifdef _HAVE_MATLAB_MODULES_
/* serial input macros: */
#define NAME (mxArray*)prhs[0]
/* serial output macros: */
#define ENUMOUT (mxArray**)&plhs[0]
#endif

#ifdef _HAVE_PYTHON_MODULES_
/* serial input macros: */
#define NAME PyTuple_GetItem(args,0)
/* serial output macros: */
#define ENUMOUT output,0
#endif

/* serial arg counts: */
#undef NLHS
#define NLHS  1
#undef NRHS
#define NRHS  1

#undef __FUNCT__ 
#define __FUNCT__  "StringToEnum"

/* local prototypes: */
void StringToEnumUsage(void);

#endif  /* _TEST_H */
