/*\file StringToEnum.c
 *\brief:convert enum (int) to string
 */

#include "./StringToEnum.h"

WRAPPER(StringToEnum){

	char    *name    = NULL;
	int      enum_out;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments: */
	CHECKARGUMENTS(NLHS,NRHS,&StringToEnumUsage);

	/*Fetch inputs: */
	FetchData(&name,NAME);

	/*Run core function: */
	enum_out=StringToEnumx(name);

	/* output: */
	WriteData(ENUMOUT,enum_out);

	/*end module: */
	MODULEEND();
}

void StringToEnumUsage(void)
{
	_pprintLine_("");
	_pprintLine_("   usage: " << __FUNCT__ << "enum = StringToEnum(string);");
	_pprintLine_("");
}
