#module imports
import numpy
from fielddisplay import fielddisplay
from EnumDefinitions import *
from checkfield import *
from WriteData import *
from isnans import *

class rifts(object):
	"""
	RIFTS class definition

	   Usage:
	      rifts=rifts();
	"""

	#properties
	def __init__(self):
		# {{{ Properties
		self.riftstruct     = float('NaN')
		self.riftproperties = float('NaN')

		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(self):
		# {{{ Display
		string='   rifts parameters:'

		string="%s\n\n%s"%(string,fielddisplay(self,'riftstruct','structure containing all rift information (vertices coordinates, segments, type of melange, ...)'))
		string="%s\n%s"%(string,fielddisplay(self,'riftproperties',''))
		return string
		#}}}
		
	def setdefaultparameters(self):
		# {{{setdefaultparameters
		return self
	#}}}

	def checkconsistency(self,md,solution,analyses):    # {{{
		if (not self.riftstruct) or any(isnans(self.riftstruct)):
			numrifts=0
		else:
			numrifts=len(self.riftstruct)

		if numrifts:
			if not md.mesh.dimension==2:
				md.checkmessage("models with rifts are only supported in 2d for now!")
			if not isinstance(self.riftstruct,list):
				md.checkmessage("rifts.riftstruct should be a structure!")
			if any(md.mesh.segmentmarkers>=2):
				#We have segments with rift markers, but no rift structure!
				md.checkmessage("model should be processed for rifts (run meshprocessrifts)!")
			md = checkfield(md,'rifts.riftstruct.fill','values',[WaterEnum(),AirEnum(),IceEnum(),MelangeEnum()])
		else:
			if any(numpy.logical_not(isnans(self.riftstruct))):
				md.checkmessage("riftstruct shoud be NaN since numrifts is 0!")

		return md
	# }}}

	def marshall(self,fid):    # {{{

		#Process rift info
		if (not self.riftstruct) or any(isnans(self.riftstruct)):
			numrifts=0
		else:
			numrifts=len(self.riftstruct)

		numpairs=0
		for i in xrange(0,numrifts):
			numpairs+=numpy.size(self.riftstruct[i].penaltypairs,0)

		# 2 for nodes + 2 for elements+ 2 for  normals + 1 for length + 1 for fill + 1 for friction + 1 for fraction + 1 for fractionincrement + 1 for state.
		data=numpy.zeros(numpairs,12)
		count=0
		for i in xrange(0,numrifts):
			numpairsforthisrift=numpy.size(self.riftstruct[i]['penaltypairs'],0)
			data[count:count+numpairsforthisrift-1,0:6]=self.riftstruct[i]['penaltypairs']
			data[count:count+numpairsforthisrift-1,7]=self.riftstruct[i]['fill']
			data[count:count+numpairsforthisrift-1,8]=self.riftstruct[i]['friction']
			data[count:count+numpairsforthisrift-1,9]=self.riftstruct[i]['fraction']
			data[count:count+numpairsforthisrift-1,10]=self.riftstruct[i]['fractionincrement']
			data[count:count+numpairsforthisrift-1,11]=self.riftstruct[i]['state']
			count+=numpairsforthisrift

		WriteData(fid,'data',numrifts,'enum',RiftsNumriftsEnum(),'format','Integer')
		WriteData(fid,'data',data,'enum',RiftsRiftstructEnum(),'format','DoubleMat','mattype',3)
	# }}}

