from pairoptions import *
from FlagElements import *

def recover_areas(md,*args):
	"""
	RECOVER_AREAS - flag the element depending on the physical model that is assigned to them

	   This routine is called by setelementstype, do not use

	   Usage:
	      [hutterflag macayealflag pattynflag stokesflag filltype]=recover_areas(md,varargin);
	"""

	#go through varargin, extract options and plug them into subtype options, by order of appearance
	options=pairoptions(*args)
#	options=deleteduplicates(options,1);

	#recover elements distribution
	hutterflag  =FlagElements(md,options.getfieldvalue('hutter',''))
	macayealflag=FlagElements(md,options.getfieldvalue('macayeal',''))
	pattynflag  =FlagElements(md,options.getfieldvalue('pattyn',''))
	stokesflag  =FlagElements(md,options.getfieldvalue('stokes',''))
	filltype    =options.getfieldvalue('fill','none')

	return hutterflag,macayealflag,pattynflag,stokesflag,filltype

