function [hutterflag macayealflag pattynflag stokesflag filltype]=recover_areas(md,varargin);
%RECOVER_AREAS - flag the element depending on the physical model that is assigned to them
%
%   This routine is called by setelementstype, do not use
%
%   Usage:
%      [hutterflag macayealflag pattynflag stokesflag filltype]=recover_areas(md,varargin);

	%go through varargin, extract options and plug them into subtype options, by order of appearance
	options=pairoptions(varargin{:});
	options=deleteduplicates(options,1);

	%recover elements distribution
	hutterflag  =FlagElements(md,getfieldvalue(options,'hutter',''));
	macayealflag=FlagElements(md,getfieldvalue(options,'macayeal',''));
	pattynflag  =FlagElements(md,getfieldvalue(options,'pattyn',''));
	stokesflag  =FlagElements(md,getfieldvalue(options,'stokes',''));
	filltype    =getfieldvalue(options,'fill','none');

end %end function


