import socket
import platform
import subprocess
import os
import shutil
from MatlabFuncs import *

def scpin(host, login,port,path, packages):
	"""
	SCPIN get packages from host, using scp on unix, and pscp on windows
 
	   usage: scpin(host,packages,path)
	"""

	#first get hostname
	hostname=socket.gethostname().lower().split('.')[0]

	#first be sure packages are not in the current directory, this could conflict with pscp on windows. 
	#remove warnings in case the files do not exist
	for package in packages:
		try:
			os.remove(package)
		except OSError as e:
			pass

	#if hostname and host are the same, do a simple copy
	if strcmpi(hostname,host):

		for package in packages:
			try:
				shutil.copy(os.path.join(path,package),os.getcwd())    #keep going, even if success=0
			except OSError as e:
				pass

	else:

		if 'Windows' in platform.system():
			#use the putty project pscp.exe: it should be in the path.
		
			#get ISSM_DIR variable
			if 'ISSM_DIR_WIN' in os.environ:
				ISSM_DIR=os.environ['ISSM_DIR_WIN'][1:-2]
			else:
				raise OSError("scpin error message: could not find ISSM_DIR_WIN environment variable.")

			username=raw_input('Username: (quoted string) ')
			key=raw_input('Key: (quoted string) ')

			for package in packages:
				try:
					subprocess.check_call('%s/externalpackages/ssh/pscp.exe -l "%s" -pw "%s" %s:%s %s' % (ISSM_DIR,username,key,host,os.path.join(path,package),os.getcwd()),shell=True)
				except CalledProcessError as e:
					raise CalledProcessError("scpin error message: could not call putty pscp.")

		else:
			#just use standard unix scp
			#string to copy multiple files using scp: 
			if len(packages)==1:
				string=packages[0]
			else:
				string='{'
				for package in packages:
					string+=packages[i]+','
				string=string[:-1]+'}'


			if port:
				subprocess.call('scp -P %d %s@localhost:%s %s' % (port,login,os.path.join(path,string),os.getcwd),shell=True)
			else:
				subprocess.call('scp %s@%s:%s %s' % (login,host,os.path.join(path,string),os.getcwd),shell=True)
		
			#check scp worked
			for package in packages:
				if not os.path.exists(os.path.join('.',package)):
					raise OSError("scpin error message: could not call scp on *nix system.")

