function expdoc()
%EXPDOC - create a doc for EXP routines
%
%   Usage:
%      expdoc()

disp(' ');
disp('   Utilities dedicated to ARGUS Files (''.exp'' extension)'); 
disp('     expboxgen: creates a domain outline box for a .tif image for the mosaic tiff');
disp('            usage: expboxgen(x0,y0,nx,ny,parameter_filename,box_filename)');
disp('            x0,y0 and nx,ny are the cropping coordinates (upper left and lower right corners in the larger tiff image)');
disp('            paramter_filename is the parameter file name for the mosaic tiff image. box_filename is self explanatory.');
disp('     expconcatenate: display all the profiles present in an Argus file and merge them accordingly to the tips selected by the user')
disp('            usage:  expconcatenate(newfile,oldfile)')
disp('     expcreatecircle: creates a closed Argus contour centered on (x,y), of radius radius_length. The contour is made of N points');
disp('            usage: expcreatecircle(filename,x0,y0,radius_length,N)');
disp('     expcreatecontour: creates a closed Argus contour delimited by the ''clicks'' of the user');
disp('            usage: expcreatecontour(filename)');
disp('     expcreateprofile: creates an Argus profile delimited by the ''clicks'' of the user');
disp('            usage: expcreateprofile(filename)');
disp('     expcut: display the contents of an Argus file and allow the user cut the profiles');
disp('            usage: expcut(newfilename,oldfilename)');
disp('     expdisp: display the contents of an Argus file');
disp('            usage:  expdisp(filename,[figure number],[line style])');
disp('     expgen: creates an Argus file from a contour (x,y) and a flag indicating if the contour must be closed or open');
disp('            usage:  expgen(filename,contours,close_flag)');
disp('     explink: takes a domain outline made of various segments, and links them together in one domain outline. Use expview to see end result');
disp('            usage: explink(domainoutline,minthreshold,step)');
disp('     exptool: allows the user to create, close, merge, remove,... Argus files and save the result in newfile');
disp('            usage: exptool(newfile,[oldfile1],[oldfile2],[oldfile3],[...]');
disp('     expread: reads an Argus file and build a structure that holds all the information of the file');
disp('            usage: expread(file,close_flag)');
disp('     expselect: display all the profiles of oldfile, the user clicks on the contour he/she wants to remove. Results saved in newfile');
disp('            usage: expselect(newfile,oldfile)');
disp('     expwrite: writes an Argus file from a structure given in input???');
disp('            usage: expwrite(structure,filename)');
