function md=planetmesher(md,varargin)
%PLANETMESHER - create planet mesh using several packages
%
%   This routine creates a planet mesh using several packages: a custom made 
%   ISSM mesher (called planetmixedmesh.m, method 'mixed') and the planettrimesh
%   (method 'tria')
%   where md is a @planet object, varargin is a list of options
%
% Usage: md=planetmesher(md,'method','mixed','radius',6378000,'angleresol',1);
%        md=planetmesher(md,'method','tria','shape','iso','radius',6378000,'refinement',5);
%
%

	%recover options
	options=pairoptions(varargin{:});

	method=getfieldvalue(options,'method','mixed');

	if strcmpi(method,'mixed'),
		%recover radius and angleresol: 
		radius=getfieldvalue(options,'radius',6378000); %earth radius as default
		angleresol=getfieldvalue(options,'angleresol',10); %10 degree resolution

		%call mixed mesh 
		md=planetmixedmesh(md,radius,angleresol);
	else
		%recover radius, shape and level of refinmenet
		radius=getfieldvalue(options,'radius',6378000); %earth radius as default
		refinement=getfieldvalue(options,'refinement',5); %refine 5 times
		shape=getfieldvalue(options,'shape','ico'); 

		%call triangular mesh
		md=planettrimesh(md,shape,radius,refinement);
	end
end
