#ISSM_DIR and ISSM_ARCH should have been defined already in your shell settings file (.bashrc, .cshrc, etc ...)

#Load ISSM scripts
setenv PATH {$PATH}:{$ISSM_DIR}/scripts

#MATLAB
set MATLAB_DIR="$ISSM_DIR/externalpackages/matlab/install"
if (-d MATLAB_DIR) then
	setenv MATLAB_DIR {$MATLAB_DIR}
	setenv PATH {$MATLAB_DIR}/bin:{$PATH}
	setenv LD_LIBRARY_PATH {$LD_LIBRARY_PATH}:{$MATLAB_DIR}/bin/glnxa64
endif

#MPI
set MPI_DIR="$ISSM_DIR/externalpackages/mpich2/install"
if (-d $MPI_DIR) then
	setenv MPI_DIR {$MPI_DIR}
	setenv PATH {$MPI_DIR}/bin:{$PATH}
	setenv LD_LIBRARY_PATH {$LD_LIBRARY_PATH}:$MPI_DIR/lib
	setenv MANPATH {$MANPATH}:$MPI_DIR/man
endif

#PETSC
set PETSC_DIR="$ISSM_DIR/externalpackages/petsc/install"
if (-d $PETSC_DIR) then
	setenv PETSC_DIR {$PETSC_DIR}
	setenv LD_LIBRARY_PATH {$LD_LIBRARY_PATH}:$PETSC_DIR/lib/{$ISSM_ARCH}
endif

#SLEPC
set SLEPC_DIR="$ISSM_DIR/externalpackages/slepc/install"
if (-d $SLEPC_DIR) then
	setenv LD_LIBRARY_PATH {$LD_LIBRARY_PATH}:$SLEPC_DIR/lib/{$ISSM_ARCH}
endif

#Dakota
set DAKOTA_DIR="$ISSM_DIR/externalpackages/dakota/install"
if (-d $DAKOTA_DIR) then
	setenv PATH {$PATH}:{$DAKOTA_DIR}/bin
	setenv MANPATH {$MANPATH}:{$MPI_DIR}/man:{$DAKOTA_DIR}/docs/man:{$DAKOTA_DIR}/docs/man-ref
endif

#Doxygen
set DOXYGEN_DIR="$ISSM_DIR/externalpackages/doxygen/install"
if (-d $DOXYGEN_DIR) then
	setenv MANPATH {$MANPATH}:{$DOXYGEN_DIR}/man
	setenv PATH {$PATH}:{$DOXYGEN_DIR}/bin
endif

#AUTOCONF
set AUTOCONF_DIR="$ISSM_DIR/externalpackages/autoconf/install"
if (-d $AUTOCONF_DIR) then
	setenv PATH {$AUTOCONF_DIR}/bin:{$PATH}
endif

#AUTOMAKE
set AUTOMAKE_DIR="$ISSM_DIR/externalpackages/automake/install"
if (-d $AUTOMAKE_DIR) then
	setenv PATH {$AUTOMAKE_DIR}/bin:{$PATH}
endif

#SSH
set SSH_DIR="$ISSM_DIR/externalpackages/ssh"
if (-d $SSH_DIR) then
	setenv PATH {$PATH}:{$SSH_DIR}
endif

#VALGRIND
set VALGRIND_DIR="$ISSM_DIR/externalpackages/valgrind/install/bin"
if (-d $VALGRIND_DIR) then
	setenv PATH {$PATH}:{$VALGRIND_DIR}
endif

#MERCURIAL
set MERCURIAL_DIR="$ISSM_DIR/externalpackages/mercurial/install"
if (-d $MERCURIAL_DIR) then
	setenv PYTHONPATH {$MERCURIAL_DIR}/mercurial/pure/
	setenv PATH {$PATH}:{$MERCURIAL_DIR}
endif

#GSL
set GSL_DIR="$ISSM_DIR/externalpackages/gsl/install"
if (-d $GSL_DIR) then
	setenv LD_LIBRARY_PATH {$LD_LIBRARY_PATH}:{$GSL_DIR}/lib
endif

#CMAKE
set CMAKE_DIR="$ISSM_DIR/externalpackages/cmake/install"
if (-d $CMAKE_DIR) then
	setenv PATH {$PATH}:{$CMAKE_DIR}/bin
endif
