#!/bin/bash
#Synchronize Matlab and C Enums
#Create a matlab file using the same Enum as in EnumDefinitions.cpp
#and move the file to src/m/shared

#Get the list of interesting lines of EnumDefinitions.cpp and introduce line number
echo "Synchronizong with Matlab's Enums..."
cat EnumDefinitions.cpp | grep "return" | grep "int" | awk '{ printf "line%so %s\n", NR, $0 }' | sed -e "s/(void){//"  > temp

#get number of lines in temp
NUMBEROFLINES=`wc -l temp | awk '{printf("%s",$1);}'`;

# go through the lines of temp
for i in `seq 1 1 $NUMBEROFLINES`; do

	#Get name and enum of the line i
	NAME=`cat temp |  awk '/line'$i'o/ {printf("%s\n",$3);}';`;
	ENUM=`cat temp |  awk '/line'$i'o/ {printf("%s\n",$5);}';`;
	echo writing file $NAME \($i/$NUMBEROFLINES\)

	#write corresponding Matlab file
	cat <<END > `echo $NAME.m`
function macro=$(echo $NAME)()
%$(echo `echo $NAME | sed -e "s/[a-z]/\U&/g"`) - Enum of $(echo `echo $NAME | sed -e "s/Enum//"`)
%
%   to be synchronized with the corresponding C Enum
%   located in src/c/EnumDefinitions
%
%   Usage:
%      macro=$(echo $NAME)()

macro=$(echo $ENUM)
END

	#move file to m/shared
	mv $NAME.m $ISSM_DIR/src/m/shared/

done

#clean up
rm temp
