function plot_overlay(md,data,options_structure,width,i)
%PLOT_OVERLAY - superimpose radar image to a given field
%
%   Usage:
%      plot_overlay(md,options_structure,width,i);
%
%   See also: PLOTMODEL


%check that buildoverlay has not already been called
redo=1;
if (ischar(data) & isstruct(md.mesh2grid_parameters) & ismember(data,mesh2grid_parameters)),
	choice=input(['mesh2grid has already been called for the parameter ''' data '''. Do you want to call it again (y/n)?'],'s');
	if strcmp(choice,'y')
		disp('use previous mesh2grid result');
		redo=0;
	end
end

if redo
	%process mesh and data
	[x y z elements is2d]=processmesh(md,options_structure);
	[data isongrid]=processdata(md,data,options_structure);

	%apply caxis if required
	if ~isnan(options_structure.caxis),
		data(find(data<options_structure.caxis(1)))=options_structure.caxis(1);
		data(find(data>options_structure.caxis(2)))=options_structure.caxis(2);
	end

	%check is2d
	if ~is2d, 
		error('buildoverlay error message: overlay not supported for 3d meshes, project on a layer');
	end

	%Ok, first we need to recover the radar map.
	if ~isnan(options_structure.xlim),
		xlim=options_structure.xlim;
	else
		xlim=[min(md.x) max(md.x)];
	end
	if ~isnan(options_structure.ylim),
		ylim=options_structure.ylim;
	else
		ylim=[min(md.y) max(md.y)];
	end
	if ~any(isnan(md.sarxm)) & ~any(isnan(md.sarym))
		choice=input('This model seems to have a radar power image. Do you want to use it? (y/n)','s');
		if ~strcmp(choice,'y')
			md=radarpower(md,xlim,ylim,options_structure.highres);
		end
	else
		md=radarpower(md,xlim,ylim,options_structure.highres);
	end


	writefile('contours.exp',md.domainoutline);
	contours=expread('contours.exp',0);
	contours=contours(1); %just keep the outer domain outline.
	delete('contours.exp');

	%use mesh2grid solution to get an gridded data to display using imagesc
	if isongrid,
		interpolation='node';
	else
		interpolation='element';
	end
	data_mesh2grid=GriddataMeshToGrid(elements,x,y,contours,data,min(xlim),max(ylim),...
		(max(xlim)-min(xlim))/length(md.sarxm),(max(ylim)-min(ylim))/length(md.sarym),length(md.sarym),length(md.sarxm),...
		interpolation,'average',options_structure.windowsize);
else
	%process mesh and data
	[x y z elements is2d]=processmesh(md,options_structure);
	[data isongrid]=processdata(md,data,options_structure);

	%get previous result
	data_mesh2grid=mesh2grid_results(find(ismember(data,mesh2grid_parameters)));
end

%Ok, we have two images, double format: 
radar=md.sarpwr;

%nullify NaN in results
data_mesh2grid(find(isnan(data_mesh2grid)))=0;

%Build hsv color image from radar and results
transparency=options_structure.alpha;
border=options_structure.border;

%intensity
v=radar/max(max(radar));

%hue
%cut results under 1.5, and log
data_mesh2grid(find(data_mesh2grid<1.5))=1.5;
h=bytscl(log(data_mesh2grid))/(255+1); %1 offset on colormap

%saturation
s=(0.5+data_mesh2grid/125)/transparency;s(find(s>1))=1;s(find(s<0))=0;
s(find(data_mesh2grid==1.5))=0;

%Include border
v((1:border),:)=0;  v((end-border+1:end),:)=0; v(:,1:border)=0;v(:,(end-border+1:end))=0;

%Transform hsv to rgb
image_hsv=zeros(size(data_mesh2grid,1),size(data_mesh2grid,2),3);
image_hsv(:,:,1)=h;
image_hsv(:,:,2)=s;
image_hsv(:,:,3)=v;
image_rgb=hsv2rgb(image_hsv);

%Select plot area 
subplot(width,width,i);

%Plot: 
imagesc(md.sarxm,md.sarym,image_rgb);set(gca,'YDir','normal');

%Apply options, without colorbar and without grid
if ~isnan(options_structure.fontsize),
	fontsize=options_structure.fontsize;
else
	fontsize=14;
end
if isnan(options_structure.axis),
	options_structure.axis='equal off';
end
if isnan(options_structure.colorbarpos),
	options_structure.colorbarpos=[0.80 0.70 0.02 0.15];
end
iscolorbar=(options_structure.colorbar==1 | isnan(options_structure.colorbar));
options_structure.colorbar=0;
applyoptions(md,data,options_structure);

%colorbar
if iscolorbar,

	%create colorbar with correct colors and position
	colorbar_rgb=buildoverlaycolorbar(md,data,options_structure.alpha);
	colorbar_handle=colorbar; 
	colorbar_image_handle=get(colorbar_handle,'Children'); 
	set(colorbar_image_handle,'CData',colorbar_rgb);
	set(colorbar_handle,'Position',options_structure.colorbarpos);

	%modify ticks.
	data(find(data<1.5))=1.5;
	scalestring=get(colorbar_handle,'YTickLabel');
	scalevalues=get(colorbar_handle,'YTick');
	scaleminmax=caxis;
	numvalues=length(scalevalues);

	scalestring=[];
	for i=1:numvalues,
		fraction=(scalevalues(i)-scaleminmax(1))/(scaleminmax(2)-scaleminmax(1));
		scalevalues(i)=round_ice(exp(min(log(data))+(max(log(data))-min(log(data)))*fraction),2);
		scalestring=[scalestring; sprintf('%8.4g',scalevalues(i))];
	end
	set(colorbar_handle,'YTickLabel',scalestring);
	set(colorbar_handle,'YColor','y');
	set(colorbar_handle,'FontSize',fontsize);
end
