#module imports
from fielddisplay import fielddisplay

class transient(object):
	#properties
	def __init__(self):
		# {{{ Properties
		self.isprognostic      = 0
		self.isdiagnostic      = 0
		self.isthermal         = 0
		self.isgroundingline   = 0
		self.requested_outputs = float('NaN')

		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(obj):
		# {{{ Display
		string='   transient solution parameters:'
		string="%s\n%s"%(string,fielddisplay(obj,'isprognostic','indicates if a prognostic solution is used in the transient'))
		string="%s\n%s"%(string,fielddisplay(obj,'isthermal','indicates if a thermal solution is used in the transient'))
		string="%s\n%s"%(string,fielddisplay(obj,'isdiagnostic','indicates if a diagnostic solution is used in the transient'))
		string="%s\n%s"%(string,fielddisplay(obj,'isgroundingline','indicates if a groundingline migration is used in the transient'))
		string="%s\n%s"%(string,fielddisplay(obj,'requested_outputs','list of additional outputs requested'))
		return string
		#}}}
		
	def setdefaultparameters(obj):
		# {{{setdefaultparameters
		
		#full analysis: Diagnostic, Prognostic and Thermal but no groundingline migration for now
		obj.isprognostic=1
		obj.isdiagnostic=1
		obj.isthermal=1
		obj.isgroundingline=0

		return obj
	#}}}

