#module imports
from fielddisplay import fielddisplay

class prognostic(object):
	#properties
	def __init__(self):
		# {{{ Properties
		self.spcthickness           = float('NaN')
		self.min_thickness          = 0
		self.hydrostatic_adjustment = 0
		self.stabilization          = 0
		self.vertex_pairing         = float('NaN')
		self.penalty_factor         = 0

		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(obj):
		# {{{ Display
		string='   Prognostic solution parameters:'
		string="%s\n\n%s"%(string,fielddisplay(obj,'spcthickness','thickness constraints (NaN means no constraint)'))
		string="%s\n%s"%(string,fielddisplay(obj,'min_thickness','minimum ice thickness allowed'))
		string="%s\n%s"%(string,fielddisplay(obj,'hydrostatic_adjustment','adjustment of ice shelves surface and bed elevations: ''Incremental'' or ''Absolute'' '))
		string="%s\n%s"%(string,fielddisplay(obj,'stabilization','0->no, 1->artificial_diffusivity, 2->streamline upwinding, 3->discontinuous Galerkin'))

		return string
		#}}}
		
	def setdefaultparameters(obj):
		# {{{setdefaultparameters
		
		#Type of stabilization to use 0:nothing 1:artificial_diffusivity 3:Discontinuous Galerkin
		obj.stabilization=1

		#Factor applied to compute the penalties kappa=max(stiffness matrix)*10^penalty_factor
		obj.penalty_factor=3

		#Minimum ice thickness that can be used
		obj.min_thickness=1

		#Hydrostatic adjustment
		obj.hydrostatic_adjustment='Absolute'

		return obj
	#}}}

