#module imports
from fielddisplay import fielddisplay

class hydrology(object):
	#properties
	def __init__(self):
		# {{{ Properties
		self.spcwatercolumn = float('NaN')
		self.n              = 0
		self.CR             = 0
		self.p              = 0
		self.q              = 0
		self.kn             = 0
		self.stabilization  = 0

		#set defaults
		self.setdefaultparameters()

	
		#}}}
	def __repr__(obj):
		# {{{ Display
		
		string='   hydrology solution parameters:'
		string="%s\n\n%s"%(string,fielddisplay(obj,'spcwatercolumn','water thickness constraints (NaN means no constraint)'))
		string="%s\n%s"%(string,fielddisplay(obj,'n','Manning roughness coefficient'))
		string="%s\n%s"%(string,fielddisplay(obj,'CR','tortuosity parameter'))
		string="%s\n%s"%(string,fielddisplay(obj,'p','dimensionless exponent in Manning velocity formula'))
		string="%s\n%s"%(string,fielddisplay(obj,'q','dimensionless exponent in Manning velocity formula'))
		string="%s\n%s"%(string,fielddisplay(obj,'kn','parameter in effective pressure formula'))
		string="%s\n%s"%(string,fielddisplay(obj,'stabilization','artificial diffusivity (default is 1). can be more than 1 to increase diffusivity.'))
		return string
		#}}}
		
	def setdefaultparameters(obj):
		# {{{setdefaultparameters
		
		#Parameters from Johnson's 2002 thesis, section 3.5.4			 
		obj.n=.02			
		obj.CR=.01
		obj.p=2
		obj.q=1
		obj.kn=0

		#Type of stabilization to use 0:nothing 1:artificial_diffusivity
		obj.stabilization=1

		return obj
	#}}}

