" Vim syntax file
" Language:	C
" Maintainer:	Bram Moolenaar <Bram@vim.org>
" Last Change:	1999 Dec 02, 2004 Feb 04

" For version 5.x: Clear all syntax items
" For version 6.x: Quit when a syntax file was already loaded
if version < 600
  syntax clear
elseif exists("b:current_syntax")
  finish
endif
"hi clear

syn match       cName		"\<[a-zA-Z_][a-zA-Z_0-9]*\>"
"syn match       cConstant	"\<[A-Z_][A-Z_0-9]\{2,}[A-Za-z_0-9]*\>[^(:]"me=e-1
"syn match       cConstant	"\<[A-Z_][A-Z_0-9]\{2,}[A-Za-z_0-9]*\>$"
"syn match       cConstant	"\<_[_0-9]\{1,}\>[^(:]"
syn match	cFunction	"\<[a-zA-Z_][a-zA-Z_0-9]*\>[^()]*)("me=e-2
"syn match	cFunction	"\<[a-zA-Z_][a-zA-Z_0-9]*\>\s*)("me=e-2
syn match	cFunction	"\<[a-zA-Z_][a-zA-Z_0-9]*\>\s*("me=e-1
syn match	cBraces		"[{}]"

syn keyword cMC			__DI __EI __asm __set_il
syn keyword cMC			__wait_nop __mul __div __mod __mulu __divu __modu
syn keyword cAnsiFunction	MULU_ DIVU_ MODU_ MUL_ DIV_ MOD_
syn keyword cAnsiFunction	main typeof
syn keyword cAnsiFunction	open close read write lseek dup dup2
syn keyword cAnsiFunction	fcntl ioctl
syn keyword cAnsiFunction	wctrans towctrans towupper
syn keyword cAnsiFunction	towlower wctype iswctype
syn keyword cAnsiFunction	iswxdigit iswupper iswspace
syn keyword cAnsiFunction	iswpunct iswprint iswlower
syn keyword cAnsiFunction	iswgraph iswdigit iswcntrl
syn keyword cAnsiFunction	iswalpha iswalnum wcsrtombs
syn keyword cAnsiFunction	mbsrtowcs wcrtomb mbrtowc
syn keyword cAnsiFunction	mbrlen mbsinit wctob
syn keyword cAnsiFunction	btowc wcsfxtime wcsftime
syn keyword cAnsiFunction	wmemset wmemmove wmemcpy
syn keyword cAnsiFunction	wmemcmp wmemchr wcstok
syn keyword cAnsiFunction	wcsstr wcsspn wcsrchr
syn keyword cAnsiFunction	wcspbrk wcslen wcscspn
syn keyword cAnsiFunction	wcschr wcsxfrm wcsncmp
syn keyword cAnsiFunction	wcscoll wcscmp wcsncat
syn keyword cAnsiFunction	wcscat wcsncpy wcscpy
syn keyword cAnsiFunction	wcstoull wcstoul wcstoll
syn keyword cAnsiFunction	wcstol wcstold wcstof
syn keyword cAnsiFunction	wcstod ungetwc putwchar
syn keyword cAnsiFunction	putwc getwchar getwc
syn keyword cAnsiFunction	fwide fputws fputwc
syn keyword cAnsiFunction	fgetws fgetwc wscanf
syn keyword cAnsiFunction	wprintf vwscanf vwprintf
syn keyword cAnsiFunction	vswscanf vswprintf vfwscanf
syn keyword cAnsiFunction	vfwprintf swscanf swprintf
syn keyword cAnsiFunction	fwscanf fwprintf zonetime
syn keyword cAnsiFunction	strfxtime strftime localtime
syn keyword cAnsiFunction	gmtime ctime asctime
syn keyword cAnsiFunction	time mkxtime mktime
syn keyword cAnsiFunction	difftime clock strlen
syn keyword cAnsiFunction	strerror memset strtok
syn keyword cAnsiFunction	strstr strspn strrchr
syn keyword cAnsiFunction	strpbrk strcspn strchr
syn keyword cAnsiFunction	memchr strxfrm strncmp
syn keyword cAnsiFunction	strcoll strcmp memcmp
syn keyword cAnsiFunction	strncat strcat strncpy
syn keyword cAnsiFunction	strcpy memmove memcpy
syn keyword cAnsiFunction	wcstombs mbstowcs wctomb
syn keyword cAnsiFunction	mbtowc mblen lldiv
syn keyword cAnsiFunction	ldiv div llabs
syn keyword cAnsiFunction	labs abs qsort
syn keyword cAnsiFunction	bsearch system getenv
syn keyword cAnsiFunction	exit atexit abort
syn keyword cAnsiFunction	realloc malloc free
syn keyword cAnsiFunction	calloc srand rand
syn keyword cAnsiFunction	strtoull strtoul strtoll
syn keyword cAnsiFunction	strtol strtold strtof
syn keyword cAnsiFunction	strtod atoll atol
syn keyword cAnsiFunction	atoi atof perror
syn keyword cAnsiFunction	ferror feof clearerr
syn keyword cAnsiFunction	rewind ftell fsetpos
syn keyword cAnsiFunction	fseek fgetpos fwrite
syn keyword cAnsiFunction	fread ungetc puts
syn keyword cAnsiFunction	putchar putc gets
syn keyword cAnsiFunction	getchar getc fputs
syn keyword cAnsiFunction	fputc fgets fgetc
syn keyword cAnsiFunction	vsscanf vsprintf vsnprintf
syn keyword cAnsiFunction	vscanf vprintf vfscanf
syn keyword cAnsiFunction	vfprintf sscanf sprintf
syn keyword cAnsiFunction	snprintf scanf printf
syn keyword cAnsiFunction	fscanf fprintf setvbuf
syn keyword cAnsiFunction	setbuf freopen fopen
syn keyword cAnsiFunction	fflush fclose tmpnam
syn keyword cAnsiFunction	tmpfile rename remove
syn keyword cAnsiFunction	offsetof va_start va_end
syn keyword cAnsiFunction	va_copy va_arg raise signal
syn keyword cAnsiFunction	longjmp setjmp isunordered
syn keyword cAnsiFunction	islessgreater islessequal isless
syn keyword cAnsiFunction	isgreaterequal isgreater fmal
syn keyword cAnsiFunction	fmaf fma fminl
syn keyword cAnsiFunction	fminf fmin fmaxl
syn keyword cAnsiFunction	fmaxf fmax fdiml
syn keyword cAnsiFunction	fdimf fdim nextafterxl
syn keyword cAnsiFunction	nextafterxf nextafterx nextafterl
syn keyword cAnsiFunction	nextafterf nextafter nanl
syn keyword cAnsiFunction	nanf nan copysignl
syn keyword cAnsiFunction	copysignf copysign remquol
syn keyword cAnsiFunction	remquof remquo remainderl
syn keyword cAnsiFunction	remainderf remainder fmodl
syn keyword cAnsiFunction	fmodf fmod truncl
syn keyword cAnsiFunction	truncf trunc llroundl
syn keyword cAnsiFunction	llroundf llround lroundl
syn keyword cAnsiFunction	lroundf lround roundl
syn keyword cAnsiFunction	roundf round llrintl
syn keyword cAnsiFunction	llrintf llrint lrintl
syn keyword cAnsiFunction	lrintf lrint rintl
syn keyword cAnsiFunction	rintf rint nearbyintl
syn keyword cAnsiFunction	nearbyintf nearbyint floorl
syn keyword cAnsiFunction	floorf floor ceill
syn keyword cAnsiFunction	ceilf ceil tgammal
syn keyword cAnsiFunction	tgammaf tgamma lgammal
syn keyword cAnsiFunction	lgammaf lgamma erfcl
syn keyword cAnsiFunction	erfcf erfc erfl
syn keyword cAnsiFunction	erff erf sqrtl
syn keyword cAnsiFunction	sqrtf sqrt powl
syn keyword cAnsiFunction	powf pow hypotl
syn keyword cAnsiFunction	hypotf hypot fabsl
syn keyword cAnsiFunction	fabsf fabs cbrtl
syn keyword cAnsiFunction	cbrtf cbrt scalblnl
syn keyword cAnsiFunction	scalblnf scalbln scalbnl
syn keyword cAnsiFunction	scalbnf scalbn modfl
syn keyword cAnsiFunction	modff modf logbl
syn keyword cAnsiFunction	logbf logb log2l
syn keyword cAnsiFunction	log2f log2 log1pl
syn keyword cAnsiFunction	log1pf log1p log10l
syn keyword cAnsiFunction	log10f log10 logl
syn keyword cAnsiFunction	logf log ldexpl
syn keyword cAnsiFunction	ldexpf ldexp ilogbl
syn keyword cAnsiFunction	ilogbf ilogb frexpl
syn keyword cAnsiFunction	frexpf frexp expm1l
syn keyword cAnsiFunction	expm1f expm1 exp2l
syn keyword cAnsiFunction	exp2f exp2 expl
syn keyword cAnsiFunction	expf exp tanhl
syn keyword cAnsiFunction	tanhf tanh sinhl
syn keyword cAnsiFunction	sinhf sinh coshl
syn keyword cAnsiFunction	coshf cosh atanhl
syn keyword cAnsiFunction	atanhf atanh asinhl
syn keyword cAnsiFunction	asinhf asinh acoshl
syn keyword cAnsiFunction	acoshf acosh tanl
syn keyword cAnsiFunction	tanf tan sinl
syn keyword cAnsiFunction	sinf sin cosl
syn keyword cAnsiFunction	cosf cos atan2l
syn keyword cAnsiFunction	atan2f atan2 atanl
syn keyword cAnsiFunction	atanf atan asinl
syn keyword cAnsiFunction	asinf asin acosl
syn keyword cAnsiFunction	acosf acos signbit
syn keyword cAnsiFunction	isnormal isnan isinf
syn keyword cAnsiFunction	isfinite fpclassify localeconv
syn keyword cAnsiFunction	setlocale wcstoumax wcstoimax
syn keyword cAnsiFunction	strtoumax strtoimax feupdateenv
syn keyword cAnsiFunction	fesetenv feholdexcept fegetenv
syn keyword cAnsiFunction	fesetround fegetround fetestexcept
syn keyword cAnsiFunction	fesetexceptflag feraiseexcept fegetexceptflag
syn keyword cAnsiFunction	feclearexcept toupper tolower
syn keyword cAnsiFunction	isxdigit isupper isspace
syn keyword cAnsiFunction	ispunct isprint islower
syn keyword cAnsiFunction	isgraph isdigit iscntrl
syn keyword cAnsiFunction	isalpha isalnum creall
syn keyword cAnsiFunction	crealf creal cprojl
syn keyword cAnsiFunction	cprojf cproj conjl
syn keyword cAnsiFunction	conjf conj cimagl
syn keyword cAnsiFunction	cimagf cimag cargl
syn keyword cAnsiFunction	cargf carg csqrtl
syn keyword cAnsiFunction	csqrtf csqrt cpowl
syn keyword cAnsiFunction	cpowf cpow cabsl
syn keyword cAnsiFunction	cabsf cabs clogl
syn keyword cAnsiFunction	clogf clog cexpl
syn keyword cAnsiFunction	cexpf cexp ctanhl
syn keyword cAnsiFunction	ctanhf ctanh csinhl
syn keyword cAnsiFunction	csinhf csinh ccoshl
syn keyword cAnsiFunction	ccoshf ccosh catanhl
syn keyword cAnsiFunction	catanhf catanh casinhl
syn keyword cAnsiFunction	casinhf casinh cacoshl
syn keyword cAnsiFunction	cacoshf cacosh ctanl
syn keyword cAnsiFunction	ctanf ctan csinl
syn keyword cAnsiFunction	csinf csin ccosl
syn keyword cAnsiFunction	ccosf ccos catanl
syn keyword cAnsiFunction	catanf catan casinl
syn keyword cAnsiFunction	casinf casin cacosl
syn keyword cAnsiFunction	cacosf cacos assert
syn keyword cAnsiFunction	UINTMAX_C INTMAX_C UINT64_C
syn keyword cAnsiFunction	UINT32_C UINT16_C UINT8_C
syn keyword cAnsiFunction	INT64_C INT32_C INT16_C INT8_C

syn keyword	cMC		__interrupt __nosavereg
syn keyword	cAnsiName	PRId8 PRIi16 PRIo32 PRIu64
syn keyword	cAnsiName	PRId16 PRIi32 PRIo64 PRIuLEAST8
syn keyword	cAnsiName	PRId32 PRIi64 PRIoLEAST8 PRIuLEAST16
syn keyword	cAnsiName	PRId64 PRIiLEAST8 PRIoLEAST16 PRIuLEAST32
syn keyword	cAnsiName	PRIdLEAST8 PRIiLEAST16 PRIoLEAST32 PRIuLEAST64
syn keyword	cAnsiName	PRIdLEAST16 PRIiLEAST32 PRIoLEAST64 PRIuFAST8
syn keyword	cAnsiName	PRIdLEAST32 PRIiLEAST64 PRIoFAST8 PRIuFAST16
syn keyword	cAnsiName	PRIdLEAST64 PRIiFAST8 PRIoFAST16 PRIuFAST32
syn keyword	cAnsiName	PRIdFAST8 PRIiFAST16 PRIoFAST32 PRIuFAST64
syn keyword	cAnsiName	PRIdFAST16 PRIiFAST32 PRIoFAST64 PRIuMAX
syn keyword	cAnsiName	PRIdFAST32 PRIiFAST64 PRIoMAX PRIuPTR
syn keyword	cAnsiName	PRIdFAST64 PRIiMAX PRIoPTR PRIx8
syn keyword	cAnsiName	PRIdMAX PRIiPTR PRIu8 PRIx16
syn keyword	cAnsiName	PRIdPTR PRIo8 PRIu16 PRIx32
syn keyword	cAnsiName	PRIi8 PRIo16 PRIu32 PRIx64

syn keyword	cAnsiName	PRIxLEAST8 SCNd8 SCNiFAST32 SCNuLEAST32
syn keyword	cAnsiName	PRIxLEAST16 SCNd16 SCNiFAST64 SCNuLEAST64
syn keyword	cAnsiName	PRIxLEAST32 SCNd32 SCNiMAX SCNuFAST8
syn keyword	cAnsiName	PRIxLEAST64 SCNd64 SCNiPTR SCNuFAST16
syn keyword	cAnsiName	PRIxFAST8 SCNdLEAST8 SCNo8 SCNuFAST32
syn keyword	cAnsiName	PRIxFAST16 SCNdLEAST16 SCNo16 SCNuFAST64
syn keyword	cAnsiName	PRIxFAST32 SCNdLEAST32 SCNo32 SCNuMAX
syn keyword	cAnsiName	PRIxFAST64 SCNdLEAST64 SCNo64 SCNuPTR
syn keyword	cAnsiName	PRIxMAX SCNdFAST8 SCNoLEAST8 SCNx8
syn keyword	cAnsiName	PRIxPTR SCNdFAST16 SCNoLEAST16 SCNx16
syn keyword	cAnsiName	PRIX8 SCNdFAST32 SCNoLEAST32 SCNx32
syn keyword	cAnsiName	PRIX16 SCNdFAST64 SCNoLEAST64 SCNx64
syn keyword	cAnsiName	PRIX32 SCNdMAX SCNoFAST8 SCNxLEAST8
syn keyword	cAnsiName	PRIX64 SCNdPTR SCNoFAST16 SCNxLEAST16
syn keyword	cAnsiName	PRIXLEAST8 SCNi8 SCNoFAST32 SCNxLEAST32
syn keyword	cAnsiName	PRIXLEAST16 SCNi16 SCNoFAST64 SCNxLEAST64
syn keyword	cAnsiName	PRIXLEAST32 SCNi32 SCNoMAX SCNxFAST8
syn keyword	cAnsiName	PRIXLEAST64 SCNi64 SCNoPTR SCNxFAST16
syn keyword	cAnsiName	PRIXFAST8 SCNiLEAST8 SCNu8 SCNxFAST32
syn keyword	cAnsiName	PRIXFAST16 SCNiLEAST16 SCNu16 SCNxFAST64
syn keyword	cAnsiName	PRIXFAST32 SCNiLEAST32 SCNu32 SCNxMAX
syn keyword	cAnsiName	PRIXFAST64 SCNiLEAST64 SCNu64 SCNxPTR
syn keyword	cAnsiName	PRIXMAX SCNiFAST8 SCNuLEAST8
syn keyword	cAnsiName	PRIXPTR SCNiFAST16 SCNuLEAST16

syn keyword	cAnsiName	errno environ
syn keyword	cAnsiName	stdout stdin stderr

syn keyword	cAnsiName	STDC CX_LIMITED_RANGE
syn keyword	cAnsiName	STDC FENV_ACCESS
syn keyword	cAnsiName	STDC FP_CONTRACT

"syn keyword	cAnsiName	acos sqrt fmod nearbyint
"syn keyword	cAnsiName	asin fabs frexp nextafter
"syn keyword	cAnsiName	atan atan2 tgamma nextafterx
"syn keyword	cAnsiName	acosh cbrt hypot remainder
"syn keyword	cAnsiName	asinh ceil ilogb remquo
"syn keyword	cAnsiName	atanh copysign ldexp rint
"syn keyword	cAnsiName	cos erf lgamma round
"syn keyword	cAnsiName	sin erfc llrint scalbn
"syn keyword	cAnsiName	tan exp2 llround scalbln
"syn keyword	cAnsiName	cosh expm1 log10 trunc
"syn keyword	cAnsiName	sinh fdim log1p carg
"syn keyword	cAnsiName	tanh floor log2 cimag
"syn keyword	cAnsiName	exp fma logb conj
"syn keyword	cAnsiName	log fmax lrint cproj
"syn keyword	cAnsiName	pow fmin lround creal

syn keyword	cAnsiName	and bitor not_eq xor
syn keyword	cAnsiName	and_eq compl or xor_eq
syn keyword	cAnsiName	bitand not or_eq

" A bunch of useful C keywords
"syn keyword	cStatement	goto
syn keyword	cStatement	break return continue asm
syn keyword	cLabel		default
syn keyword	cLabel		case
syn keyword	cConditional	if else switch
syn keyword	cRepeat		while for do

syn keyword	cTodo		contained TODO FIXME XXX
syn match	cTodo		contained "///[A-Z]!*"

" cCommentGroup allows adding matches for special things in comments
syn cluster	cCommentGroup	contains=cTodo

" String and Character constants
" Highlight special characters (those which have a backslash) differently
syn match	cSpecial	display contained "\\\(x\x\+\|\o\{1,3}\|.\|$\)"
if !exists("c_no_utf")
  syn match	cSpecial	display contained "\\\(u\x\{4}\|U\x\{8}\)"
endif
if exists("c_no_cformat")
  syn region	cString		start=+L\="+ skip=+\\\\\|\\"+ end=+"+ contains=cSpecial,@Spell
  " cCppString: same as cString, but ends at end of line
  syn region	cCppString	start=+L\="+ skip=+\\\\\|\\"\|\\$+ excludenl end=+"+ end='$' contains=cSpecial,@Spell
else
  syn match	cFormat		display "%\(\d\+\$\)\=[-+' #0*,]*\(\d*\|\*\|\*\d\+\$\)\(\.\(\d*\|\*\|\*\d\+\$\)\)\=\([hlLjztF]\|ll\|hh\)\=\([bdiuoxXDOUfeEgGcCsSpnAaK]\|\[\^\=.[^]]*\]\)" contained
  syn match	cFormat		display "%%" contained
  syn region	cString		start=+L\="+ skip=+\\\\\|\\"+ end=+"+ contains=cSpecial,cFormat,@Spell
  " cCppString: same as cString, but ends at end of line
  syn region	cCppString	start=+L\="+ skip=+\\\\\|\\"\|\\$+ excludenl end=+"+ end='$' contains=cSpecial,cFormat
  hi link cFormat cSpecial
endif
hi link cCppString cString

syn match	cCharacter	"L\='[^\\]'"
syn match	cCharacter	"L'[^']*'" contains=cSpecial
if exists("c_gnu")
  syn match	cSpecialError	"L\='\\[^'\"?\\abefnrtv]'"
  syn match	cSpecialCharacter "L\='\\['\"?\\abefnrtv]'"
else
  syn match	cSpecialError	"L\='\\[^'\"?\\abfnrtv]'"
  syn match	cSpecialCharacter "L\='\\['\"?\\abfnrtv]'"
endif
syn match	cSpecialCharacter display "L\='\\\o\{1,3}'"
syn match	cSpecialCharacter display "'\\x\x\{1,2}'"
syn match	cSpecialCharacter display "L'\\x\x\+'"

"when wanted, highlight trailing white space
if exists("c_space_errors")
  if !exists("c_no_trail_space_error")
    syn match	cSpaceError	display excludenl "\s\+$"
  endif
  if !exists("c_no_tab_space_error")
    syn match	cSpaceError	display " \+\t"me=e-1
  endif
endif

"catch errors caused by wrong parenthesis and brackets
" also accept <% for {, %> for }, <: for [ and :> for ] (C99)
syn cluster	cParenGroup	contains=cParenError,cIncluded,cSpecial,cCommentSkip,cCommentString,cComment2String,@cCommentGroup,cCommentStartError,cUserCont,cUserLabel,cUserLabel2,cGotoLabel,cBitField,cCommentSkip,cOctalZero,cCppOut,cCppOut2,cCppSkip,cFormat,cNumber,cFloat,cOctal,cOctalError,cNumbersCom
if exists("c_no_bracket_error")
  syn region	cParen		transparent start='(' end=')' contains=ALLBUT,@cParenGroup,cCppParen,cCppString,@Spell
  " cCppParen: same as cParen but ends at end-of-line; used in cDefine
  syn region	cCppParen	transparent start='(' skip='\\$' excludenl end=')' end='$' contained contains=ALLBUT,@cParenGroup,cParen,cString,@Spell
  syn match	cParenError	display ")"
" syn match	cErrInParen	display contained "[{}]\|<%\|%>"
  syn match	cErrInParen	display contained "[]\|<%\|%>"
else
  syn region	cParen		transparent start='(' end=')' contains=ALLBUT,@cParenGroup,cCppParen,cErrInBracket,cCppBracket,cCppString,@Spell
  " cCppParen: same as cParen but ends at end-of-line; used in cDefine
  syn region	cCppParen	transparent start='(' skip='\\$' excludenl end=')' end='$' contained contains=ALLBUT,@cParenGroup,cErrInBracket,cParen,cBracket,cString,@Spell
  syn match	cParenError	display "[\])]"
" syn match	cErrInParen	display contained "[\]{}]\|<%\|%>"
  syn match	cErrInParen	display contained "[\]]\|<%\|%>"
  syn region	cBracket	transparent start='\[\|<::\@!' end=']\|:>' contains=ALLBUT,@cParenGroup,cErrInParen,cCppParen,cCppBracket,cCppString,@Spell
  " cCppBracket: same as cParen but ends at end-of-line; used in cDefine
  syn region	cCppBracket	transparent start='\[\|<::\@!' skip='\\$' excludenl end=']\|:>' end='$' contained contains=ALLBUT,@cParenGroup,cErrInParen,cParen,cBracket,cString,@Spell
  syn match	cErrInBracket	display contained "[);{}]\|<%\|%>"
  "syn region	cBlock		transparent matchgroup=cBraces start='{' end='}' contains=ALLBUT,@cParenGroup,cCppParen,cCppBracket,cCppString,cBraceError,cErrInBracket
  "syn match	cBraceError	"}"
endif

"integer number, or floating point number without a dot and with "f".
syn case ignore
syn match	cNumbers	display transparent "\<\d\|\.\d" contains=cNumber,cFloat,cOctalError,cOctal
" Same, but without octal error (for comments)
syn match	cNumbersCom	display contained transparent "\<\d\|\.\d" contains=cNumber,cFloat,cOctal
syn match	cNumber		display contained "\d\+\(u\=l\{0,2}\|ll\=u\)\>"
"hex number
syn match	cNumber		display contained "0x\x\+\(u\=l\{0,2}\|ll\=u\)\>"
" Flag the first zero of an octal number as something special
syn match	cOctal		display contained "0\o\+\(u\=l\{0,2}\|ll\=u\)\>" contains=cOctalZero
syn match	cOctalZero	display contained "\<0"
syn match	cFloat		display contained "\d\+f"
"floating point number, with dot, optional exponent
syn match	cFloat		display contained "\d\+\.\d*\(e[-+]\=\d\+\)\=[fl]\="
"floating point number, starting with a dot, optional exponent
syn match	cFloat		display contained "\.\d\+\(e[-+]\=\d\+\)\=[fl]\=\>"
"floating point number, without dot, with exponent
syn match	cFloat		display contained "\d\+e[-+]\=\d\+[fl]\=\>"
if !exists("c_no_c99")
  "hexadecimal floating point number, optional leading digits, with dot, with exponent
  syn match	cFloat		display contained "0x\x*\.\x\+p[-+]\=\d\+[fl]\=\>"
  "hexadecimal floating point number, with leading digits, optional dot, with exponent
  syn match	cFloat		display contained "0x\x\+\.\=p[-+]\=\d\+[fl]\=\>"
endif

" flag an octal number with wrong digits
syn match	cOctalError	display contained "0\o*[89]\d*"
syn case match

if exists("xxxc_comment_strings")
  " A comment can contain cString, cCharacter and cNumber.
  " But a "*/" inside a cString in a cComment DOES end the comment!  So we
  " need to use a special type of cString: cCommentString, which also ends on
  " "*/", and sees a "*" at the start of the line as comment again.
  " Unfortunately this doesn't very well work for // type of comments :-(
  syntax match	cCommentSkip	contained "^\s*\*\($\|\s\+\)"
  syntax region cCommentString	contained start=+L\=\\\@<!"+ skip=+\\\\\|\\"+ end=+"+ end=+\*/+me=s-1 contains=cSpecial,cCommentSkip
  syntax region cComment2String	contained start=+L\=\\\@<!"+ skip=+\\\\\|\\"+ end=+"+ end="$" contains=cSpecial
  syntax region  cCommentL	start="//" skip="\\$" end="$" keepend contains=@cCommentGroup,cComment2String,cCharacter,cNumbersCom,cSpaceError,@Spell
  syntax region cComment	matchgroup=cCommentStart start="/\*" end="\*/" contains=@cCommentGroup,cCommentStartError,cCommentString,cCharacter,cNumbersCom,cSpaceError,@Spell
else
  syn region	cCommentL	start="//" skip="\\$" end="$" keepend contains=@cCommentGroup,cSpaceError,@Spell
  syn region	cComment	matchgroup=cCommentStart start="/\*" end="\*/" contains=@cCommentGroup,cCommentStartError,cSpaceError,@Spell
endif
" keep a // comment separately, it terminates a preproc. conditional
syntax match	cCommentError	display "\*/"
syntax match	cCommentStartError display "/\*"me=e-1 contained

syn keyword	cOperator	sizeof
if exists("c_gnu")
  syn keyword	cStatement	__asm__
  syn keyword	cOperator	typeof __real__ __imag__
endif
syn keyword	cType		int long short char void
syn keyword	cType		signed unsigned float double

"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
"   ISSM special syntax                                                                                             "
"   please try to keep the alphabetical ordering                                                                    "
"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
"ISSM containers:
syn keyword	cType		Constraints DataSet Elements Inputs Loads Materials Nodes Parameters Results Vertices Options
"Petsc
syn keyword	cType		Vec Mat SeqVec SeqMat
"other ISSM's syntax
syn keyword	cType		mxArray ErrorException QuadtreeBox IssmDouble IssmPDouble Observations

"ISSM's objects begin
syn keyword cType GaussPenta
syn keyword cType gaussobjects
syn keyword cType GaussTria
syn keyword cType objects
syn keyword cType Material
syn keyword cType Matice
syn keyword cType Matpar
syn keyword cType objects
syn keyword cType Contour
syn keyword cType DoubleInput
syn keyword cType Input
syn keyword cType ControlInput
syn keyword cType DatasetInput
syn keyword cType IntInput
syn keyword cType BoolInput
syn keyword cType TriaP1Input
syn keyword cType TransientInput
syn keyword cType PentaP1Input
syn keyword cType KML_Icon
syn keyword cType KML_Point
syn keyword cType KML_LinearRing
syn keyword cType KML_Feature
syn keyword cType KMLFileReadUtils
syn keyword cType KML_StyleSelector
syn keyword cType KML_LatLonBox
syn keyword cType KML_Attribute
syn keyword cType KML_PolyStyle
syn keyword cType KML_Object
syn keyword cType KML_SubStyle
syn keyword cType KML_LineString
syn keyword cType KML_Overlay
syn keyword cType KML_Container
syn keyword cType KML_Polygon
syn keyword cType KML_Geometry
syn keyword cType KML_ColorStyle
syn keyword cType KML_Placemark
syn keyword cType KML_Unknown
syn keyword cType KML_GroundOverlay
syn keyword cType KML_Style
syn keyword cType KML_Comment
syn keyword cType KML_MultiGeometry
syn keyword cType KML_LineStyle
syn keyword cType KML_Folder
syn keyword cType KML_Document
syn keyword cType KML_File
syn keyword cType DoubleVecParam
syn keyword cType DoubleParam
syn keyword cType DoubleMatArrayParam
syn keyword cType DoubleMatParam
syn keyword cType Param
syn keyword cType FileParam
syn keyword cType IntVecParam
syn keyword cType IntParam
syn keyword cType BoolParam
syn keyword cType IntMatParam
syn keyword cType VectorParam
syn keyword cType DoubleTransientMatParam
syn keyword cType MatrixParam
syn keyword cType StringArrayParam
syn keyword cType StringParam
syn keyword cType TransientParam
syn keyword cType OptionStruct
syn keyword cType OptionDouble
syn keyword cType OptionLogical
syn keyword cType OptionUtilities
syn keyword cType OptionChar
syn keyword cType Option
syn keyword cType OptionCell
syn keyword cType Segment
syn keyword cType Icefront
syn keyword cType Friction
syn keyword cType Riftfront
syn keyword cType Numericalflux
syn keyword cType Penpair
syn keyword cType Load
syn keyword cType Pengrid
syn keyword cType Object
syn keyword cType DoubleVecExternalResult
syn keyword cType DoubleExternalResult
syn keyword cType IntExternalResult
syn keyword cType BoolExternalResult
syn keyword cType DoubleMatExternalResult
syn keyword cType PetscVecExternalResult
syn keyword cType ExternalResult
syn keyword cType StringExternalResult
syn keyword cType Vertex
syn keyword cType SpcDynamic
syn keyword cType SpcStatic
syn keyword cType SpcTransient
syn keyword cType Constraint
syn keyword cType TriaP1ElementResult
syn keyword cType PentaP1ElementResult
syn keyword cType DoubleElementResult
syn keyword cType ElementResultLocal
syn keyword cType BoolElementResult
syn keyword cType ElementResult
syn keyword cType Node
syn keyword cType TriaRef
syn keyword cType TriaHook
syn keyword cType PentaRef
syn keyword cType PentaHook
syn keyword cType Tria
syn keyword cType Element
syn keyword cType Penta
syn keyword cType classes
syn keyword cType DofIndexing
syn keyword cType Patch
syn keyword cType Hook
syn keyword cType Quadtree
syn keyword cType Observation
syn keyword cType ExponentialVariogram
syn keyword cType GaussianVariogram
syn keyword cType SphericalVariogram
syn keyword cType PowerVariogram
syn keyword cType krigingobjects
syn keyword cType Variogram
syn keyword cType DakotaPlugin
syn keyword cType ElementVector
syn keyword cType ElementMatrix
syn keyword cType matrixobjects
syn keyword cType Vector
syn keyword cType Matrix
syn keyword cType GeomSubDomain
syn keyword cType Geometry
syn keyword cType AdjacentTriangle
syn keyword cType VertexOnEdge
syn keyword cType BamgQuadtree
syn keyword cType Edge
syn keyword cType BamgVertex
syn keyword cType SetOfE4
syn keyword cType GeomEdge
syn keyword cType Direction
syn keyword cType VertexOnGeom
syn keyword cType R2
syn keyword cType Mesh
syn keyword cType ListofIntersectionTriangles
syn keyword cType Triangle
syn keyword cType DoubleAndInt
syn keyword cType VertexOnVertex
syn keyword cType BamgOpts
syn keyword cType BamgGeom
syn keyword cType bamgobjects
syn keyword cType CrackedEdge
syn keyword cType SubDomain
syn keyword cType BamgMesh
syn keyword cType Metric
syn keyword cType include
syn keyword cType typedefs
syn keyword cType Curve
syn keyword cType macros
syn keyword cType GeomVertex
syn keyword cType OptArgs
syn keyword cType Update
syn keyword cType OptPars
syn keyword cType IoModel
syn keyword cType FemModel
"ISSM's objects end
"ISSM's Enums begin
syn keyword cConstant AutodiffForwardEnum
syn keyword cConstant AutodiffIsautodiffEnum
syn keyword cConstant AutodiffReverseEnum
syn keyword cConstant BalancethicknessSpcthicknessEnum
syn keyword cConstant BalancethicknessStabilizationEnum
syn keyword cConstant BalancethicknessThickeningRateEnum
syn keyword cConstant BasalforcingsGeothermalfluxEnum
syn keyword cConstant BasalforcingsMeltingRateCorrectionEnum
syn keyword cConstant BasalforcingsMeltingRateEnum
syn keyword cConstant BathymetryEnum
syn keyword cConstant BedEnum
syn keyword cConstant ConstantsGEnum
syn keyword cConstant ConstantsReferencetemperatureEnum
syn keyword cConstant ConstantsYtsEnum
syn keyword cConstant DiagnosticAbstolEnum
syn keyword cConstant DiagnosticIcefrontEnum
syn keyword cConstant DiagnosticIsnewtonEnum
syn keyword cConstant DiagnosticMaxiterEnum
syn keyword cConstant DiagnosticNumRequestedOutputsEnum
syn keyword cConstant DiagnosticPenaltyFactorEnum
syn keyword cConstant DiagnosticReferentialEnum
syn keyword cConstant DiagnosticReltolEnum
syn keyword cConstant DiagnosticRequestedOutputsEnum
syn keyword cConstant DiagnosticRestolEnum
syn keyword cConstant DiagnosticRiftPenaltyLockEnum
syn keyword cConstant DiagnosticRiftPenaltyThresholdEnum
syn keyword cConstant DiagnosticShelfDampeningEnum
syn keyword cConstant DiagnosticSpcvxEnum
syn keyword cConstant DiagnosticSpcvyEnum
syn keyword cConstant DiagnosticSpcvzEnum
syn keyword cConstant DiagnosticStokesreconditioningEnum
syn keyword cConstant DiagnosticVertexPairingEnum
syn keyword cConstant DiagnosticViscosityOvershootEnum
syn keyword cConstant FlowequationBordermacayealEnum
syn keyword cConstant FlowequationBorderpattynEnum
syn keyword cConstant FlowequationBorderstokesEnum
syn keyword cConstant FlowequationElementEquationEnum
syn keyword cConstant FlowequationIshutterEnum
syn keyword cConstant FlowequationIsmacayealpattynEnum
syn keyword cConstant FlowequationIsstokesEnum
syn keyword cConstant FlowequationVertexEquationEnum
syn keyword cConstant FrictionCoefficientEnum
syn keyword cConstant FrictionPEnum
syn keyword cConstant FrictionQEnum
syn keyword cConstant GeometryHydrostaticRatioEnum
syn keyword cConstant HydrologyCREnum
syn keyword cConstant HydrologyKnEnum
syn keyword cConstant HydrologyNEnum
syn keyword cConstant HydrologyPEnum
syn keyword cConstant HydrologyQEnum
syn keyword cConstant HydrologySpcwatercolumnEnum
syn keyword cConstant HydrologyStabilizationEnum
syn keyword cConstant InversionControlParametersEnum
syn keyword cConstant InversionCostFunctionEnum
syn keyword cConstant InversionCostFunctionThresholdEnum
syn keyword cConstant InversionCostFunctionsCoefficientsEnum
syn keyword cConstant InversionCostFunctionsEnum
syn keyword cConstant InversionGradientOnlyEnum
syn keyword cConstant InversionGradientScalingEnum
syn keyword cConstant InversionIscontrolEnum
syn keyword cConstant InversionTaoEnum
syn keyword cConstant InversionIncompleteAdjointEnum
syn keyword cConstant InversionMaxParametersEnum
syn keyword cConstant InversionMaxiterPerStepEnum
syn keyword cConstant InversionMinParametersEnum
syn keyword cConstant InversionNstepsEnum
syn keyword cConstant InversionNumControlParametersEnum
syn keyword cConstant InversionNumCostFunctionsEnum
syn keyword cConstant InversionStepThresholdEnum
syn keyword cConstant InversionThicknessObsEnum
syn keyword cConstant InversionVelObsEnum
syn keyword cConstant InversionVxObsEnum
syn keyword cConstant InversionVyObsEnum
syn keyword cConstant InversionVzObsEnum
syn keyword cConstant MaskElementonfloatingiceEnum
syn keyword cConstant MaskElementongroundediceEnum
syn keyword cConstant MaskElementonwaterEnum
syn keyword cConstant MaskVertexonfloatingiceEnum
syn keyword cConstant MaskVertexongroundediceEnum
syn keyword cConstant MaskVertexonwaterEnum
syn keyword cConstant MaterialsBetaEnum
syn keyword cConstant MaterialsHeatcapacityEnum
syn keyword cConstant MaterialsLatentheatEnum
syn keyword cConstant MaterialsMeltingpointEnum
syn keyword cConstant MaterialsMixedLayerCapacityEnum
syn keyword cConstant MaterialsRheologyBEnum
syn keyword cConstant MaterialsRheologyBbarEnum
syn keyword cConstant MaterialsRheologyLawEnum
syn keyword cConstant MaterialsRheologyNEnum
syn keyword cConstant MaterialsRhoIceEnum
syn keyword cConstant MaterialsRhoWaterEnum
syn keyword cConstant MaterialsRhoFreshwaterEnum
syn keyword cConstant MaterialsMuWaterEnum
syn keyword cConstant MaterialsThermalExchangeVelocityEnum
syn keyword cConstant MaterialsThermalconductivityEnum
syn keyword cConstant MeshAverageVertexConnectivityEnum
syn keyword cConstant MeshDimensionEnum
syn keyword cConstant MeshEdgesEnum
syn keyword cConstant MeshElementconnectivityEnum
syn keyword cConstant MeshElementonbedEnum
syn keyword cConstant MeshElementonsurfaceEnum
syn keyword cConstant MeshElements2dEnum
syn keyword cConstant MeshElementsEnum
syn keyword cConstant MeshLowerelementsEnum
syn keyword cConstant MeshNumberofedgesEnum
syn keyword cConstant MeshNumberofelements2dEnum
syn keyword cConstant MeshNumberofelementsEnum
syn keyword cConstant MeshNumberoflayersEnum
syn keyword cConstant MeshNumberofvertices2dEnum
syn keyword cConstant MeshNumberofverticesEnum
syn keyword cConstant MeshUpperelementsEnum
syn keyword cConstant MeshVertexonbedEnum
syn keyword cConstant MeshVertexonsurfaceEnum
syn keyword cConstant MeshXEnum
syn keyword cConstant MeshYEnum
syn keyword cConstant MeshZEnum
syn keyword cConstant MiscellaneousNameEnum
syn keyword cConstant PrognosticHydrostaticAdjustmentEnum
syn keyword cConstant PrognosticMinThicknessEnum
syn keyword cConstant PrognosticPenaltyFactorEnum
syn keyword cConstant PrognosticSpcthicknessEnum
syn keyword cConstant PrognosticStabilizationEnum
syn keyword cConstant PrognosticVertexPairingEnum
syn keyword cConstant QmuIsdakotaEnum
syn keyword cConstant QmuMassFluxSegmentsEnum
syn keyword cConstant QmuNumberofpartitionsEnum
syn keyword cConstant QmuNumberofresponsesEnum
syn keyword cConstant QmuPartitionEnum
syn keyword cConstant QmuResponsedescriptorsEnum
syn keyword cConstant QmuVariabledescriptorsEnum
syn keyword cConstant RiftsNumriftsEnum
syn keyword cConstant RiftsRiftstructEnum
syn keyword cConstant SettingsIoGatherEnum
syn keyword cConstant SettingsLowmemEnum
syn keyword cConstant SettingsOutputFrequencyEnum
syn keyword cConstant SettingsResultsAsPatchesEnum
syn keyword cConstant SettingsWaitonlockEnum
syn keyword cConstant SurfaceforcingsDelta18oEnum
syn keyword cConstant SurfaceforcingsDelta18oSurfaceEnum
syn keyword cConstant SurfaceforcingsIsdelta18oEnum
syn keyword cConstant SurfaceforcingsPrecipitationsPresentdayEnum
syn keyword cConstant SurfaceforcingsTemperaturesPresentdayEnum
syn keyword cConstant SurfaceforcingsTemperaturesLgmEnum
syn keyword cConstant DebugProfilingEnum
syn keyword cConstant ProfilingCurrentMemEnum
syn keyword cConstant ProfilingCurrentFlopsEnum
syn keyword cConstant ProfilingSolutionTimeEnum
syn keyword cConstant MaxIterationConvergenceFlagEnum
syn keyword cConstant SteadystateMaxiterEnum
syn keyword cConstant SteadystateNumRequestedOutputsEnum
syn keyword cConstant SteadystateReltolEnum
syn keyword cConstant SteadystateRequestedOutputsEnum
syn keyword cConstant SurfaceEnum
syn keyword cConstant SurfaceforcingsPrecipitationEnum
syn keyword cConstant SurfaceforcingsMassBalanceEnum
syn keyword cConstant SurfaceforcingsIspddEnum
syn keyword cConstant SurfaceforcingsIssmbgradientsEnum
syn keyword cConstant SurfaceforcingsMonthlytemperaturesEnum
syn keyword cConstant SurfaceforcingsHcEnum
syn keyword cConstant SurfaceforcingsSmbPosMaxEnum
syn keyword cConstant SurfaceforcingsSmbPosMinEnum
syn keyword cConstant SurfaceforcingsAPosEnum
syn keyword cConstant SurfaceforcingsBPosEnum
syn keyword cConstant SurfaceforcingsANegEnum
syn keyword cConstant SurfaceforcingsBNegEnum
syn keyword cConstant ThermalMaxiterEnum
syn keyword cConstant ThermalPenaltyFactorEnum
syn keyword cConstant ThermalPenaltyLockEnum
syn keyword cConstant ThermalPenaltyThresholdEnum
syn keyword cConstant ThermalSpctemperatureEnum
syn keyword cConstant ThermalStabilizationEnum
syn keyword cConstant ThermalIsenthalpyEnum
syn keyword cConstant ThicknessEnum
syn keyword cConstant TimesteppingStartTimeEnum
syn keyword cConstant TimesteppingFinalTimeEnum
syn keyword cConstant TimesteppingCflCoefficientEnum
syn keyword cConstant TimesteppingTimeAdaptEnum
syn keyword cConstant TimesteppingTimeStepEnum
syn keyword cConstant TransientIsdiagnosticEnum
syn keyword cConstant TransientIsgroundinglineEnum
syn keyword cConstant TransientIsprognosticEnum
syn keyword cConstant TransientIsthermalEnum
syn keyword cConstant TransientNumRequestedOutputsEnum
syn keyword cConstant TransientRequestedOutputsEnum
syn keyword cConstant SolutionTypeEnum
syn keyword cConstant AnalysisTypeEnum
syn keyword cConstant ConfigurationTypeEnum
syn keyword cConstant AdjointBalancethicknessAnalysisEnum
syn keyword cConstant AdjointHorizAnalysisEnum
syn keyword cConstant AdjointSolutionEnum
syn keyword cConstant AnalysisCounterEnum
syn keyword cConstant BalancethicknessAnalysisEnum
syn keyword cConstant BalancethicknessSolutionEnum
syn keyword cConstant BedSlopeAnalysisEnum
syn keyword cConstant BedSlopeSolutionEnum
syn keyword cConstant BedSlopeXAnalysisEnum
syn keyword cConstant BedSlopeYAnalysisEnum
syn keyword cConstant DiagnosticHorizAnalysisEnum
syn keyword cConstant DiagnosticHutterAnalysisEnum
syn keyword cConstant DiagnosticSolutionEnum
syn keyword cConstant DiagnosticVertAnalysisEnum
syn keyword cConstant EnthalpyAnalysisEnum
syn keyword cConstant EnthalpySolutionEnum
syn keyword cConstant FlaimAnalysisEnum
syn keyword cConstant FlaimSolutionEnum
syn keyword cConstant HydrologyAnalysisEnum
syn keyword cConstant HydrologySolutionEnum
syn keyword cConstant MeltingAnalysisEnum
syn keyword cConstant NoneAnalysisEnum
syn keyword cConstant PrognosticAnalysisEnum
syn keyword cConstant PrognosticSolutionEnum
syn keyword cConstant SteadystateSolutionEnum
syn keyword cConstant SurfaceSlopeAnalysisEnum
syn keyword cConstant SurfaceSlopeSolutionEnum
syn keyword cConstant SurfaceSlopeXAnalysisEnum
syn keyword cConstant SurfaceSlopeYAnalysisEnum
syn keyword cConstant ThermalAnalysisEnum
syn keyword cConstant ThermalSolutionEnum
syn keyword cConstant TransientSolutionEnum
syn keyword cConstant ApproximationEnum
syn keyword cConstant HutterApproximationEnum
syn keyword cConstant MacAyealApproximationEnum
syn keyword cConstant MacAyealPattynApproximationEnum
syn keyword cConstant MacAyealStokesApproximationEnum
syn keyword cConstant NoneApproximationEnum
syn keyword cConstant PattynApproximationEnum
syn keyword cConstant PattynStokesApproximationEnum
syn keyword cConstant StokesApproximationEnum
syn keyword cConstant ConstraintsEnum
syn keyword cConstant LoadsEnum
syn keyword cConstant MaterialsEnum
syn keyword cConstant NodesEnum
syn keyword cConstant ParametersEnum
syn keyword cConstant VerticesEnum
syn keyword cConstant ResultsEnum
syn keyword cConstant BoolInputEnum
syn keyword cConstant BoolParamEnum
syn keyword cConstant ContourEnum
syn keyword cConstant ControlInputEnum
syn keyword cConstant DatasetInputEnum
syn keyword cConstant DofIndexingEnum
syn keyword cConstant DoubleInputEnum
syn keyword cConstant DoubleMatArrayParamEnum
syn keyword cConstant DoubleMatParamEnum
syn keyword cConstant DoubleParamEnum
syn keyword cConstant DoubleVecParamEnum
syn keyword cConstant ElementEnum
syn keyword cConstant ElementResultEnum
syn keyword cConstant ExternalResultEnum
syn keyword cConstant FileParamEnum
syn keyword cConstant HookEnum
syn keyword cConstant IcefrontEnum
syn keyword cConstant InputEnum
syn keyword cConstant IntInputEnum
syn keyword cConstant IntParamEnum
syn keyword cConstant IntVecParamEnum
syn keyword cConstant TransientParamEnum
syn keyword cConstant MacAyeal2dIceFrontEnum
syn keyword cConstant MacAyeal3dIceFrontEnum
syn keyword cConstant MaticeEnum
syn keyword cConstant MatparEnum
syn keyword cConstant NodeEnum
syn keyword cConstant NumericalfluxEnum
syn keyword cConstant ParamEnum
syn keyword cConstant PattynIceFrontEnum
syn keyword cConstant PengridEnum
syn keyword cConstant PenpairEnum
syn keyword cConstant PentaEnum
syn keyword cConstant PentaP1InputEnum
syn keyword cConstant MatrixParamEnum
syn keyword cConstant VectorParamEnum
syn keyword cConstant RiftfrontEnum
syn keyword cConstant SegmentEnum
syn keyword cConstant SegmentRiftfrontEnum
syn keyword cConstant SpcDynamicEnum
syn keyword cConstant SpcStaticEnum
syn keyword cConstant SpcTransientEnum
syn keyword cConstant StokesIceFrontEnum
syn keyword cConstant StringArrayParamEnum
syn keyword cConstant StringParamEnum
syn keyword cConstant TriaEnum
syn keyword cConstant TriaP1InputEnum
syn keyword cConstant VertexEnum
syn keyword cConstant AirEnum
syn keyword cConstant IceEnum
syn keyword cConstant MelangeEnum
syn keyword cConstant WaterEnum
syn keyword cConstant ClosedEnum
syn keyword cConstant FreeEnum
syn keyword cConstant OpenEnum
syn keyword cConstant AdjointpEnum
syn keyword cConstant AdjointxEnum
syn keyword cConstant AdjointyEnum
syn keyword cConstant AdjointzEnum
syn keyword cConstant BedSlopeXEnum
syn keyword cConstant BedSlopeYEnum
syn keyword cConstant BoundaryEnum
syn keyword cConstant ConstantEnum
syn keyword cConstant ConvergedEnum
syn keyword cConstant ExtToIuEnum
syn keyword cConstant FillEnum
syn keyword cConstant FractionIncrementEnum
syn keyword cConstant FrictionEnum
syn keyword cConstant GroundinglineMeltingRateEnum
syn keyword cConstant InternalEnum
syn keyword cConstant IuToExtEnum
syn keyword cConstant MassFluxEnum
syn keyword cConstant MaxPenetrationEnum
syn keyword cConstant MeltingOffsetEnum
syn keyword cConstant MisfitEnum
syn keyword cConstant NumberNodeToElementConnectivityEnum
syn keyword cConstant PressureEnum
syn keyword cConstant PressurePicardEnum
syn keyword cConstant QmuPressureEnum
syn keyword cConstant QmuVxEnum
syn keyword cConstant QmuVyEnum
syn keyword cConstant QmuVzEnum
syn keyword cConstant QmuThicknessEnum
syn keyword cConstant QmuBedEnum
syn keyword cConstant QmuSurfaceEnum
syn keyword cConstant QmuMeltingEnum
syn keyword cConstant ResetPenaltiesEnum
syn keyword cConstant SegmentOnIceShelfEnum
syn keyword cConstant SurfaceAbsVelMisfitEnum
syn keyword cConstant SurfaceAreaEnum
syn keyword cConstant SurfaceAverageVelMisfitEnum
syn keyword cConstant SurfaceLogVelMisfitEnum
syn keyword cConstant SurfaceLogVxVyMisfitEnum
syn keyword cConstant SurfaceRelVelMisfitEnum
syn keyword cConstant SurfaceSlopeXEnum
syn keyword cConstant SurfaceSlopeYEnum
syn keyword cConstant TemperatureEnum
syn keyword cConstant TemperatureOldEnum
syn keyword cConstant TemperaturePicardEnum
syn keyword cConstant ThicknessAbsMisfitEnum
syn keyword cConstant TypeEnum
syn keyword cConstant VelEnum
syn keyword cConstant VelocityEnum
syn keyword cConstant VxAverageEnum
syn keyword cConstant VxEnum
syn keyword cConstant VxPicardEnum
syn keyword cConstant VyAverageEnum
syn keyword cConstant VyEnum
syn keyword cConstant VyPicardEnum
syn keyword cConstant VzEnum
syn keyword cConstant VzMacAyealEnum
syn keyword cConstant VzPattynEnum
syn keyword cConstant VzPicardEnum
syn keyword cConstant VzStokesEnum
syn keyword cConstant VxMeshEnum
syn keyword cConstant VyMeshEnum
syn keyword cConstant VzMeshEnum
syn keyword cConstant EnthalpyEnum
syn keyword cConstant EnthalpyPicardEnum
syn keyword cConstant ThicknessAbsGradientEnum
syn keyword cConstant StepResponsesEnum
syn keyword cConstant IntMatParamEnum
syn keyword cConstant RheologyBbarAbsGradientEnum
syn keyword cConstant DragCoefficientAbsGradientEnum
syn keyword cConstant TransientInputEnum
syn keyword cConstant OutputfilenameEnum
syn keyword cConstant WaterfractionEnum
syn keyword cConstant WatercolumnEnum
syn keyword cConstant BasalFrictionEnum
syn keyword cConstant ViscousHeatingEnum
syn keyword cConstant QmuTemperatureEnum
syn keyword cConstant HydrologyWaterVxEnum
syn keyword cConstant HydrologyWaterVyEnum
syn keyword cConstant StressTensorEnum
syn keyword cConstant StressTensorxxEnum
syn keyword cConstant StressTensorxyEnum
syn keyword cConstant StressTensorxzEnum
syn keyword cConstant StressTensoryyEnum
syn keyword cConstant StressTensoryzEnum
syn keyword cConstant StressTensorzzEnum
syn keyword cConstant IceVolumeEnum
syn keyword cConstant TotalSmbEnum
syn keyword cConstant ThicknessAlongGradientEnum
syn keyword cConstant ThicknessAcrossGradientEnum
syn keyword cConstant P0Enum
syn keyword cConstant P1Enum
syn keyword cConstant P1DGEnum
syn keyword cConstant SaveResultsEnum
syn keyword cConstant BoolElementResultEnum
syn keyword cConstant BoolExternalResultEnum
syn keyword cConstant DoubleElementResultEnum
syn keyword cConstant DoubleExternalResultEnum
syn keyword cConstant DoubleMatExternalResultEnum
syn keyword cConstant DoubleVecExternalResultEnum
syn keyword cConstant IntExternalResultEnum
syn keyword cConstant JEnum
syn keyword cConstant PatchEnum
syn keyword cConstant PatchNodesEnum
syn keyword cConstant PatchVerticesEnum
syn keyword cConstant PentaP1ElementResultEnum
syn keyword cConstant PetscVecExternalResultEnum
syn keyword cConstant StringExternalResultEnum
syn keyword cConstant StepEnum
syn keyword cConstant TimeEnum
syn keyword cConstant TriaP1ElementResultEnum
syn keyword cConstant WaterColumnOldEnum
syn keyword cConstant MinVelEnum
syn keyword cConstant MaxVelEnum
syn keyword cConstant MinVxEnum
syn keyword cConstant MaxVxEnum
syn keyword cConstant MaxAbsVxEnum
syn keyword cConstant MinVyEnum
syn keyword cConstant MaxVyEnum
syn keyword cConstant MaxAbsVyEnum
syn keyword cConstant MinVzEnum
syn keyword cConstant MaxVzEnum
syn keyword cConstant MaxAbsVzEnum
syn keyword cConstant RelativeEnum
syn keyword cConstant AbsoluteEnum
syn keyword cConstant IncrementalEnum
syn keyword cConstant AgressiveMigrationEnum
syn keyword cConstant NoneEnum
syn keyword cConstant SoftMigrationEnum
syn keyword cConstant StokesSolverEnum
syn keyword cConstant AdjointEnum
syn keyword cConstant ColinearEnum
syn keyword cConstant ControlSteadyEnum
syn keyword cConstant FsetEnum
syn keyword cConstant Gradient1Enum
syn keyword cConstant Gradient2Enum
syn keyword cConstant Gradient3Enum
syn keyword cConstant GradientEnum
syn keyword cConstant GroundinglineMigrationEnum
syn keyword cConstant GsetEnum
syn keyword cConstant IndexEnum
syn keyword cConstant IndexedEnum
syn keyword cConstant IntersectEnum
syn keyword cConstant NodalEnum
syn keyword cConstant OldGradientEnum
syn keyword cConstant OutputFilePointerEnum
syn keyword cConstant PetscOptionsAnalysesEnum
syn keyword cConstant PetscOptionsStringsEnum
syn keyword cConstant QmuErrNameEnum
syn keyword cConstant QmuInNameEnum
syn keyword cConstant QmuOutNameEnum
syn keyword cConstant RegularEnum
syn keyword cConstant ScaledEnum
syn keyword cConstant SeparateEnum
syn keyword cConstant SsetEnum
syn keyword cConstant VerboseEnum
syn keyword cConstant TriangleInterpEnum
syn keyword cConstant BilinearInterpEnum
syn keyword cConstant NearestInterpEnum
syn keyword cConstant XYEnum
syn keyword cConstant XYZPEnum
syn keyword cConstant OptionEnum
syn keyword cConstant OptionCellEnum
syn keyword cConstant OptionCharEnum
syn keyword cConstant OptionStructEnum
syn keyword cConstant OptionDoubleEnum
syn keyword cConstant OptionLogicalEnum
syn keyword cConstant PatersonEnum
syn keyword cConstant ArrheniusEnum
"ISSM's Enums end
