#module imports
from fielddisplay import fielddisplay
from EnumDefinitions import *
from checkfield import *
from WriteData import *

class materials:
	#properties
	def __init__(self):
		# {{{ Properties
		self.rho_ice                    = 0
		self.rho_water                  = 0
		self.mu_water                   = 0
		self.heatcapacity               = 0
		self.latentheat                 = 0
		self.thermalconductivity        = 0
		self.meltingpoint               = 0
		self.beta                       = 0
		self.mixed_layer_capacity       = 0
		self.thermal_exchange_velocity  = 0
		self.rheology_B   = float('NaN')
		self.rheology_n   = float('NaN')
		self.rheology_law = ""

		self.setdefaultparameters()
		#}}}
	def __repr__(obj):
		# {{{ Display
		string="   Materials:"

		string="%s\n\n%s"%(string,fielddisplay(obj,"rho_ice","ice density [kg/m^3]"))
		string="%s\n%s"%(string,fielddisplay(obj,"rho_water","water density [kg/m^3]"))
		string="%s\n%s"%(string,fielddisplay(obj,"mu_water","water viscosity [N s/m^2]"))
		string="%s\n%s"%(string,fielddisplay(obj,"heatcapacity","heat capacity [J/kg/K]"))
		string="%s\n%s"%(string,fielddisplay(obj,"thermalconductivity","ice thermal conductivity [W/m/K]"))
		string="%s\n%s"%(string,fielddisplay(obj,"meltingpoint","melting point of ice at 1atm in K"))
		string="%s\n%s"%(string,fielddisplay(obj,"latentheat","latent heat of fusion [J/m^3]"))
		string="%s\n%s"%(string,fielddisplay(obj,"beta","rate of change of melting point with pressure [K/Pa]"))
		string="%s\n%s"%(string,fielddisplay(obj,"mixed_layer_capacity","mixed layer capacity [W/kg/K]"))
		string="%s\n%s"%(string,fielddisplay(obj,"thermal_exchange_velocity","thermal exchange velocity [m/s]"))
		string="%s\n%s"%(string,fielddisplay(obj,"rheology_B","flow law parameter [Pa/s^(1/n)]"))
		string="%s\n%s"%(string,fielddisplay(obj,"rheology_n","Glen""s flow law exponent"))
		string="%s\n%s"%(string,fielddisplay(obj,"rheology_law","law for the temperature dependance of the rheology: ""None"", ""Paterson"" or ""Arrhenius"""))

		return string
		#}}}
	def setdefaultparameters(obj):
		# {{{setdefaultparameters
		#ice density (kg/m^3)
		obj.rho_ice=917

		#water density (kg/m^3)
		obj.rho_water=1023

		#water viscosity (N.s/m^2)
		obj.mu_water=0.001787  

		#ice heat capacity cp (J/kg/K)
		obj.heatcapacity=2093

		#ice latent heat of fusion L (J/kg)
		obj.latentheat=3.34*10**5

		#ice thermal conductivity (W/m/K)
		obj.thermalconductivity=2.4

		#the melting point of ice at 1 atmosphere of pressure in K
		obj.meltingpoint=273.15

		#rate of change of melting point with pressure (K/Pa)
		obj.beta=9.8*10**-8

		#mixed layer (ice-water interface) heat capacity (J/kg/K)
		obj.mixed_layer_capacity=3974

		#thermal exchange velocity (ice-water interface) (m/s)
		obj.thermal_exchange_velocity=1.00*10**-4

		#Rheology law: what is the temperature dependence of B with T
		#available: none, paterson and arrhenius
		obj.rheology_law='Paterson'
		return obj
		#}}}

	def checkconsistency(self,md,solution,analyses):    # {{{
		md = checkfield(md,'materials.rho_ice','>',0)
		md = checkfield(md,'materials.rho_water','>',0)
		md = checkfield(md,'materials.rho_freshwater','>',0)
		md = checkfield(md,'materials.mu_water','>',0)
		md = checkfield(md,'materials.rheology_B','>',0,'size',[md.mesh.numberofvertices])
		md = checkfield(md,'materials.rheology_n','>',0,'size',[md.mesh.numberofelements])
		md = checkfield(md,'materials.rheology_law','values',['None','Paterson','Arrhenius'])
		return md
	# }}}

	def marshall(self,fid):    # {{{
		WriteData(fid,'object',self,'fieldname','rho_ice','format','Double')
		WriteData(fid,'object',self,'fieldname','rho_water','format','Double')
		WriteData(fid,'object',self,'fieldname','rho_freshwater','format','Double')
		WriteData(fid,'object',self,'fieldname','mu_water','format','Double')
		WriteData(fid,'object',self,'fieldname','heatcapacity','format','Double')
		WriteData(fid,'object',self,'fieldname','latentheat','format','Double')
		WriteData(fid,'object',self,'fieldname','thermalconductivity','format','Double')
		WriteData(fid,'object',self,'fieldname','meltingpoint','format','Double')
		WriteData(fid,'object',self,'fieldname','beta','format','Double')
		WriteData(fid,'object',self,'fieldname','mixed_layer_capacity','format','Double')
		WriteData(fid,'object',self,'fieldname','thermal_exchange_velocity','format','Double')
		WriteData(fid,'object',self,'fieldname','rheology_B','format','DoubleMat','mattype',1)
		WriteData(fid,'object',self,'fieldname','rheology_n','format','DoubleMat','mattype',2)
		WriteData(fid,'data',StringToEnum(self.rheology_law),'enum',MaterialsRheologyLawEnum,'format','Integer')
	# }}}

