#module imports
import numpy
from fielddisplay import fielddisplay
from EnumDefinitions import *
from checkfield import *
from WriteData import *

class initialization:
	#properties
	def __init__(self):
		# {{{ Properties
		
		self.vx            = float('NaN')
		self.vy            = float('NaN')
		self.vz            = float('NaN')
		self.vel           = float('NaN')
		self.pressure      = float('NaN')
		self.temperature   = float('NaN')
		self.watercolumn   = float('NaN')
		self.waterfraction = float('NaN')

		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(obj):
		# {{{ Display
		string='   initial field values:'

		string="%s\n%s"%(string,fielddisplay(obj,'vx','x component of velocity'))
		string="%s\n%s"%(string,fielddisplay(obj,'vy','y component of velocity'))
		string="%s\n%s"%(string,fielddisplay(obj,'vz','z component of velocity'))
		string="%s\n%s"%(string,fielddisplay(obj,'vel','velocity norm'))
		string="%s\n%s"%(string,fielddisplay(obj,'pressure','pressure field'))
		string="%s\n%s"%(string,fielddisplay(obj,'temperature','temperature in Kelvins'))
		string="%s\n%s"%(string,fielddisplay(obj,'watercolumn','thickness of subglacial water'))
		string="%s\n%s"%(string,fielddisplay(obj,'waterfraction','fraction of water in the ice'))

		return string
		#}}}
		
	def setdefaultparameters(obj):
		# {{{setdefaultparameters
		return obj
	#}}}

	def checkconsistency(obj,md,solution,analyses):    # {{{
		if DiagnosticHorizAnalysisEnum in analyses:
			if not any(numpy.isnan(md.initialization.vx) or numpy.isnan(md.initialization.vy)):
				md = checkfield(md,'initialization.vx','NaN',1,'size',[md.mesh.numberofvertices])
				md = checkfield(md,'initialization.vy','NaN',1,'size',[md.mesh.numberofvertices])
		if PrognosticAnalysisEnum in analyses:
			md = checkfield(md,'initialization.vx','NaN',1,'size',[md.mesh.numberofvertices])
			md = checkfield(md,'initialization.vy','NaN',1,'size',[md.mesh.numberofvertices])
		if HydrologyAnalysisEnum in analyses:
			md = checkfield(md,'initialization.watercolumn','NaN',1,'size',[md.mesh.numberofvertices])
		if BalancethicknessAnalysisEnum in analyses:
			md = checkfield(md,'initialization.vx','NaN',1,'size',[md.mesh.numberofvertices])
			md = checkfield(md,'initialization.vy','NaN',1,'size',[md.mesh.numberofvertices])
			#Triangle with zero velocity
			if any(numpy.logical_and(numpy.sum(numpy.abs(md.initialization.vx[md.mesh.elements.astype(int)-1]),axis=1)==0,\
			                         numpy.sum(numpy.abs(md.initialization.vy[md.mesh.elements.astype(int)-1]),axis=1)==0)):
				md.checkmessage("at least one triangle has all its vertices with a zero velocity")
		if ThermalAnalysisEnum in analyses:
			md = checkfield(md,'initialization.vx','NaN',1,'size',[md.mesh.numberofvertices])
			md = checkfield(md,'initialization.vy','NaN',1,'size',[md.mesh.numberofvertices])
			md = checkfield(md,'initialization.vz','NaN',1,'size',[md.mesh.numberofvertices])
			md = checkfield(md,'initialization.pressure','NaN',1,'size',[md.mesh.numberofvertices])
		if (EnthalpyAnalysisEnum in analyses and md.thermal.isenthalpy) or solution==EnthalpySolutionEnum:
			md = checkfield(md,'initialization.waterfraction','>=',0,'size',[md.mesh.numberofvertices])

		return md
	# }}}

	def marshall(obj,fid):    # {{{
		WriteData(fid,'data',obj.vx,'format','DoubleMat','mattype',1,'enum',VxEnum)
		WriteData(fid,'data',obj.vy,'format','DoubleMat','mattype',1,'enum',VyEnum)
		WriteData(fid,'data',obj.vz,'format','DoubleMat','mattype',1,'enum',VzEnum)
		WriteData(fid,'data',obj.pressure,'format','DoubleMat','mattype',1,'enum',PressureEnum)
		WriteData(fid,'data',obj.temperature,'format','DoubleMat','mattype',1,'enum',TemperatureEnum)
		WriteData(fid,'data',obj.watercolumn,'format','DoubleMat','mattype',1,'enum',WatercolumnEnum)
		WriteData(fid,'data',obj.waterfraction,'format','DoubleMat','mattype',1,'enum',WaterfractionEnum)
	# }}}

