#module imports
from fielddisplay import fielddisplay
from EnumDefinitions import *
from checkfield import *
from WriteData import *

class geometry:
	#properties
	def __init__(self):
		# {{{ Properties
		self.surface           = float('NaN')
		self.thickness         = float('NaN')
		self.bed               = float('NaN')
		self.bathymetry        = float('NaN')
		self.hydrostatic_ratio = float('NaN')

		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(obj):
		# {{{ Display

		string="   geometry parameters:"

		string="%s\n\n%s"%(string,fielddisplay(obj,'surface','surface elevation'))
		string="%s\n%s"%(string,fielddisplay(obj,'thickness','ice thickness'))
		string="%s\n%s"%(string,fielddisplay(obj,'bed','bed elevation'))
		string="%s\n%s"%(string,fielddisplay(obj,'bathymetry','bathymetry elevation'))
		string="%s\n%s"%(string,fielddisplay(obj,'hydrostatic_ratio','coefficient for ice shelves'' thickness correction: hydrostatic_ratio H_obs+ (1-hydrostatic_ratio) H_hydro'))
		return string
		#}}}
		
	def setdefaultparameters(obj):
		# {{{setdefaultparameters
		return obj
	#}}}

	def checkconsistency(self,md,solution,analyses):    # {{{

		md = checkfield(md,'geometry.surface'  ,'NaN',1,'size',[md.mesh.numberofvertices])
		md = checkfield(md,'geometry.bed'      ,'NaN',1,'size',[md.mesh.numberofvertices])
		md = checkfield(md,'geometry.thickness','NaN',1,'size',[md.mesh.numberofvertices],'>',0)
		if any((self.thickness-self.surface+self.bed)>10**-9):
			md.checkmessage("equality thickness=surface-bed violated")
		end 
		if solution==TransientSolutionEnum and md.transient.isgroundingline:
			md = checkfield(md,'geometry.bathymetry','NaN',1,'size',[md.mesh.numberofvertices])

		return md
	# }}}

	def marshall(self,fid):    # {{{
		WriteData(fid,'data',self.surface,'format','DoubleMat','mattype',1,'enum',SurfaceEnum)
		WriteData(fid,'data',self.thickness,'format','DoubleMat','mattype',1,'enum',ThicknessEnum)
		WriteData(fid,'data',self.bed,'format','DoubleMat','mattype',1,'enum',BedEnum)
		WriteData(fid,'data',self.bathymetry,'format','DoubleMat','mattype',1,'enum',BathymetryEnum)
		WriteData(fid,'object',self,'fieldname','hydrostatic_ratio','format','DoubleMat','mattype',1)
	# }}}

