#module imports
from fielddisplay import fielddisplay
from EnumDefinitions import *
from checkfield import *
from WriteData import *

class friction:
	#properties
	def __init__(self):
		# {{{ Properties
		self.coefficient = float('NaN')
		self.p           = float('NaN')
		self.q           = float('NaN')

		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(obj):
		# {{{ Display
		string="Sigma= drag^2 * Neff ^r * u ^s, with Neff=rho_ice*g*thickness+rho_water*g*bed, r=q/p and s=1/p"
		string="%s\n\n%s"%(string,fielddisplay(obj,"coefficient","friction coefficient [SI]"))
		string="%s\n%s"%(string,fielddisplay(obj,"p","p exponent"))
		string="%s\n%s"%(string,fielddisplay(obj,"q","q exponent"))
		return string
		#}}}

	def setdefaultparameters(obj):
		# {{{setdefaultparameters
		return obj
	#}}}

	def checkconsistency(self,md,solution,analyses):    # {{{

		#Early return
		if not DiagnosticHorizAnalysisEnum in analyses and not ThermalAnalysisEnum in analyses:
			return md

		md = checkfield(md,'friction.coefficient','NaN',1,'size',[md.mesh.numberofvertices])
		md = checkfield(md,'friction.q','NaN',1,'size',[md.mesh.numberofelements])
		md = checkfield(md,'friction.p','NaN',1,'size',[md.mesh.numberofelements])

		return md
	# }}}

	def marshall(self,fid):    # {{{
		WriteData(fid,'object',self,'fieldname','coefficient','format','DoubleMat','mattype',1)
		WriteData(fid,'object',self,'fieldname','p','format','DoubleMat','mattype',2)
		WriteData(fid,'object',self,'fieldname','q','format','DoubleMat','mattype',2)
	# }}}

