#module imports
from fielddisplay import fielddisplay
from EnumDefinitions import *
from checkfield import *
from WriteData import *

class constants:
	#properties
	def __init__(self):
		# {{{ Properties
		self.g                    = 0
		self.yts                  = 0
		self.referencetemperature = 0
		
		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(obj):
		# {{{ Display
		string="   constants parameters:"
		string="%s\n\n%s"%(string,fielddisplay(obj,"g","gravitational acceleration"))
		string="%s\n%s"%(string,fielddisplay(obj,"yts","number of seconds in a year"))
		string="%s\n%s"%(string,fielddisplay(obj,"referencetemperature","reference temperature used in the enthalpy model"))


		return string
		#}}}
		
	def setdefaultparameters(obj):
		# {{{setdefaultparameters
		
		#acceleration due to gravity (m/s^2)
		obj.g=9.81

		#converstion from year to seconds
		obj.yts=365*24*3600

		#the reference temperature for enthalpy model (cf Aschwanden)
		obj.referencetemperature=223.15

		return obj
	#}}}

	def checkconsistency(self,md,solution,analyses):    # {{{

		md = checkfield(md,'constants.g','>',0,'size',[1])
		md = checkfield(md,'constants.yts','>',0,'size',[1])
		md = checkfield(md,'constants.referencetemperature','size',[1])

		return md
	# }}}

	def marshall(self,fid):    # {{{
		WriteData(fid,'object',self,'fieldname','g','format','Double')
		WriteData(fid,'object',self,'fieldname','yts','format','Double')
		WriteData(fid,'object',self,'fieldname','referencetemperature','format','Double')
	# }}}

