import os
from issmdir import *
from MatlabFuncs import *

def petscversion():
	"""
	PETSCVERSION - recover petsc version number, inside config.h file
 
	   Usage:
	      PETSC_VERSION=petscversion();
	"""

	#default
	PETSC_VERSION=3

	configfile=os.path.join(issmdir(),'config.h')
	if not os.path.exists(configfile):
		raise RuntimeError("File '%s' not found. ISSM has not been configured yet!" % configfile)

	#go through the file, and recover the line we want
	try:
		fid=open(configfile,'r')
	except IOError as e:
		raise IOerror("could not open file: '%s'" % configfile)

	for tline in fid:
		if strncmp(tline,'#define _PETSC_MAJOR_',21):
			PETSC_VERSION=int(tline[22])
			break

	fid.close()

	return PETSC_VERSION

