%VERBOSE class definition
%
%   Available verbosity levels:
%      mprocessor  : model processing 
%      module      : modules
%      solution    : solution sequence
%      solver      : solver info (extensive)
%      convergence : convergence criteria
%      control     : control method
%      qmu         : sensitivity analysis
%
%   Usage:
%      verbose=verbose();
%      verbose=verbose(3);
%      verbose=verbose('001100');
%      verbose=verbose('module',true,'solver',false);

%WARNING: some parts of this file are Synchronized with src/c/shared/Numerics/Verbosity.h
%         Do not modify these sections. See src/c/shared/Numerics/README for more info

classdef verbose
	properties (SetAccess=public) 
		% {{{
		%BEGINFIELDS
		mprocessor  = false;
		module      = false;
		solution    = false;
		solver      = false;
		convergence = false;
		control     = false;
		qmu         = false;
		%ENDFIELDS
		% }}}
	end
	%}}}
	methods
		function verbose=verbose(varargin) % {{{

			switch(nargin),
				case 0,
					%Don't do anything
				case 1,
					binary=varargin{1};
					if     ischar(binary),
						if strcmpi(binary,'all'),
							binary=2^11-1; %all ones
							verbose=BinaryToVerbose(verbose,binary);
							verbose.solver=false; %Do not use by default
						else
							binary=bin2dec(binary);
							verbose=BinaryToVerbose(verbose,binary);
						end
					elseif isnumeric(binary),
						verbose=BinaryToVerbose(verbose,binary);
					end 
				otherwise,
					%Use options to initialize object
					verbose=AssignObjectFields(pairoptions(varargin{:}),verbose);

					%Cast to logicals
					listproperties=properties('verbose');
					for i=1:numel(listproperties),
						fieldname=listproperties{i};
						fieldvalue=verbose.(fieldname);
						if (islogical(fieldvalue) | isnumeric(fieldvalue)) & numel(fieldvalue)==1,
							verbose.(fieldname)=logical(fieldvalue);
						else
							error('verbose supported field values are logicals only (true or false)');
						end
					end
			end
		end
		%}}}
		function binary=VerboseToBinary(verbose) % {{{

		%BEGINVERB2BIN
		binary=0;
		if (verbose.mprocessor), binary=bitor(binary,1); end
		if (verbose.module), binary=bitor(binary,2); end
		if (verbose.solution), binary=bitor(binary,4); end
		if (verbose.solver), binary=bitor(binary,8); end
		if (verbose.convergence), binary=bitor(binary,16); end
		if (verbose.control), binary=bitor(binary,32); end
		if (verbose.qmu), binary=bitor(binary,64); end
		%ENDVERB2BIN

		end
		%}}}
		function verbose=BinaryToVerbose(verbose,binary) % {{{

		%BEGINBIN2VERB
		verbose.mprocessor =logical(bitand(binary, 1));
		verbose.module     =logical(bitand(binary, 2));
		verbose.solution   =logical(bitand(binary, 4));
		verbose.solver     =logical(bitand(binary, 8));
		verbose.convergence=logical(bitand(binary,16));
		verbose.control    =logical(bitand(binary,32));
		verbose.qmu        =logical(bitand(binary,64));
		%ENDBIN2VERB

		end
		%}}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

		end % }}}
		function disp(verbose) % {{{
			
		%BEGINDISP
		disp(sprintf('class ''%s''  = ',class(verbose)));
		disp(sprintf('   %15s : %s','mprocessor',mat2str(verbose.mprocessor)));
		disp(sprintf('   %15s : %s','module',mat2str(verbose.module)));
		disp(sprintf('   %15s : %s','solution',mat2str(verbose.solution)));
		disp(sprintf('   %15s : %s','solver',mat2str(verbose.solver)));
		disp(sprintf('   %15s : %s','convergence',mat2str(verbose.convergence)));
		disp(sprintf('   %15s : %s','control',mat2str(verbose.control)));
		disp(sprintf('   %15s : %s','qmu',mat2str(verbose.qmu)));
		%ENDDISP

		end
		%}}}
		function marshall(obj,fid) % {{{
			WriteData(fid,'data',VerboseToBinary(obj),'enum',VerboseEnum,'format','Integer');
		end % }}}
	end
end
